/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.client;

import com.badlogic.gwtref.client.Parameter;
import com.badlogic.gwtref.client.ReflectionCache;
import com.badlogic.gwtref.client.Type;
import java.util.Arrays;

public class Method {
    final String name;
    final Class enclosingType;
    final Class returnType;
    final boolean isAbstract;
    final boolean isFinal;
    final boolean isStatic;
    final boolean isNative;
    final boolean isDefaultAccess;
    final boolean isPrivate;
    final boolean isProtected;
    final boolean isPublic;
    final boolean isVarArgs;
    final boolean isMethod;
    final boolean isConstructor;
    final Parameter[] parameters;
    final String methodId;
    boolean accessible;

    public Method(String name, Class enclosingType, Class returnType, Parameter[] parameters, boolean isAbstract, boolean isFinal, boolean isStatic, boolean isDefaultAccess, boolean isPrivate, boolean isProtected, boolean isPublic, boolean isNative, boolean isVarArgs, boolean isMethod, boolean isConstructor, String methodId) {
        this.name = name;
        this.enclosingType = enclosingType;
        this.parameters = parameters;
        this.returnType = returnType;
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.isStatic = isStatic;
        this.isNative = isNative;
        this.isDefaultAccess = isDefaultAccess;
        this.isPrivate = isPrivate;
        this.isProtected = isProtected;
        this.isPublic = isPublic;
        this.isVarArgs = isVarArgs;
        this.isMethod = isMethod;
        this.isConstructor = isConstructor;
        this.methodId = methodId;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public Class getEnclosingType() {
        return this.enclosingType;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isDefaultAccess() {
        return this.isDefaultAccess;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public Object invoke(Object obj, Object ... params) {
        if (this.parameters != null && (params == null || params.length != this.parameters.length)) {
            throw new IllegalArgumentException("Parameter mismatch");
        }
        if (this.parameters == null && params != null && params.length > 0) {
            throw new IllegalArgumentException("Parameter mismatch");
        }
        return ReflectionCache.instance.invoke(this, obj, params);
    }

    boolean match(String name, Class ... types) {
        if (!this.name.equals(name)) {
            return false;
        }
        if (types.length != this.parameters.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Type t2;
            Type t1 = ReflectionCache.instance.forName(this.parameters[i].getType().getName());
            if (t1 == (t2 = ReflectionCache.instance.forName(types[i].getName())) || t1.isAssignableFrom(t2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Method [name=" + this.name + ", enclosingType=" + this.enclosingType + ", returnType=" + this.returnType + ", isAbstract=" + this.isAbstract + ", isFinal=" + this.isFinal + ", isStatic=" + this.isStatic + ", isNative=" + this.isNative + ", isDefaultAccess=" + this.isDefaultAccess + ", isPrivate=" + this.isPrivate + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ", isVarArgs=" + this.isVarArgs + ", isMethod=" + this.isMethod + ", isConstructor=" + this.isConstructor + ", parameters=" + Arrays.toString(this.parameters) + ", accessible=" + this.accessible + "]";
    }
}

