/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.client;

import com.badlogic.gwtref.client.Constructor;
import com.badlogic.gwtref.client.Field;
import com.badlogic.gwtref.client.Method;
import com.badlogic.gwtref.client.ReflectionCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Type {
    String name;
    Class clazz;
    Class superClass;
    Set<Class> assignables = new HashSet<Class>();
    boolean isAbstract;
    boolean isInterface;
    boolean isPrimitive;
    boolean isEnum;
    boolean isArray;
    boolean isMemberClass;
    boolean isStatic;
    Field[] fields;
    Method[] methods;
    Constructor constructor;
    Class componentType;
    Object[] enumConstants;

    public Object newInstance() {
        return ReflectionCache.instance.newInstance(this);
    }

    public String getName() {
        return this.name;
    }

    public Class getClassOfType() {
        return this.clazz;
    }

    public Type getSuperclass() {
        try {
            return ReflectionCache.forName(this.superClass.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isAssignableFrom(Type otherType) {
        return this.assignables.contains(otherType.getClassOfType());
    }

    public Field getField(String name) {
        for (Type t = this; t != null; t = t.getSuperclass()) {
            Field[] declFields = t.getDeclaredFields();
            if (declFields == null) continue;
            for (Field f : declFields) {
                if (!f.isPublic || !f.name.equals(name)) continue;
                return f;
            }
        }
        return null;
    }

    public Field[] getFields() {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Type t = this; t != null; t = t.getSuperclass()) {
            Field[] declFields = t.getDeclaredFields();
            if (declFields == null) continue;
            for (Field f : declFields) {
                if (!f.isPublic) continue;
                allFields.add(f);
            }
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public Field[] getDeclaredFields() {
        return this.fields;
    }

    public Method getMethod(String name, Class ... parameterTypes) throws NoSuchMethodException {
        ArrayList allMethods = new ArrayList();
        for (Type t = this; t != null; t = t.getSuperclass()) {
            Method[] declMethods = t.getDeclaredMethods();
            if (declMethods == null) continue;
            for (Method m : declMethods) {
                if (!m.isPublic() || !m.match(name, parameterTypes)) continue;
                return m;
            }
        }
        throw new NoSuchMethodException();
    }

    public Method[] getMethods() {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Type t = this; t != null; t = t.getSuperclass()) {
            Method[] declMethods = t.getDeclaredMethods();
            if (declMethods == null) continue;
            for (Method m : declMethods) {
                if (!m.isPublic()) continue;
                allMethods.add(m);
            }
        }
        return allMethods.toArray(new Method[allMethods.size()]);
    }

    public Method[] getDeclaredMethods() {
        return this.methods;
    }

    public Constructor getDeclaredConstructor() throws NoSuchMethodException {
        return this.constructor;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public int getArrayLength(Object obj) {
        return ReflectionCache.instance.getArrayLength(this, obj);
    }

    public Object getArrayElement(Object obj, int i) {
        return ReflectionCache.instance.getArrayElement(this, obj, i);
    }

    public void setArrayElement(Object obj, int i, Object value) {
        ReflectionCache.instance.setArrayElement(this, obj, i, value);
    }

    public Object[] getEnumConstants() {
        return this.enumConstants;
    }

    public String toString() {
        return "Type [name=" + this.name + ",\n clazz=" + this.clazz + ",\n superClass=" + this.superClass + ",\n assignables=" + this.assignables + ",\n isAbstract=" + this.isAbstract + ",\n isInterface=" + this.isInterface + ",\n isPrimitive=" + this.isPrimitive + ",\n isEnum=" + this.isEnum + ",\n isArray=" + this.isArray + ",\n isMemberClass=" + this.isMemberClass + ",\n isStatic=" + this.isStatic + ",\n fields=" + Arrays.toString(this.fields) + ",\n methods=" + Arrays.toString(this.methods) + ",\n constructor=" + this.constructor + ",\n componentType=" + this.componentType + ",\n enumConstants=" + Arrays.toString(this.enumConstants) + "]";
    }
}

