/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private final Reader in;
    private final char[] buffer;
    private int position;
    private int limit;

    public BufferedReader(Reader in, int bufferSize) {
        this.in = in;
        this.buffer = new char[bufferSize];
    }

    public BufferedReader(Reader in) {
        this(in, 32);
    }

    private void fill() throws IOException {
        this.position = 0;
        this.limit = this.in.read(this.buffer);
    }

    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (this.position >= this.limit) {
                this.fill();
            }
            if (this.position >= this.limit) {
                return sb.length() == 0 ? null : sb.toString();
            }
            for (int i = this.position; i < this.limit; ++i) {
                if (this.buffer[i] == '\r') {
                    sb.append(this.buffer, this.position, i - this.position);
                    this.position = i + 1;
                    if (i + 1 < this.limit) {
                        if (this.buffer[i + 1] == '\n') {
                            this.position = i + 2;
                        }
                    } else {
                        this.fill();
                        if (this.buffer[this.position] == '\n') {
                            ++this.position;
                        }
                    }
                    return sb.toString();
                }
                if (this.buffer[i] != '\n') continue;
                sb.append(this.buffer, this.position, i - this.position);
                this.position = i + 1;
                return sb.toString();
            }
            sb.append(this.buffer, this.position, this.limit - this.position);
            this.position = this.limit;
        }
    }

    @Override
    public int read(char[] b, int offset, int length) throws IOException {
        int count = 0;
        if (this.position >= this.limit && length < this.buffer.length) {
            this.fill();
        }
        if (this.position < this.limit) {
            int remaining = this.limit - this.position;
            if (remaining > length) {
                remaining = length;
            }
            System.arraycopy(this.buffer, this.position, b, offset, remaining);
            count += remaining;
            this.position += remaining;
            offset += remaining;
            length -= remaining;
        }
        if (length > 0) {
            int c = this.in.read(b, offset, length);
            if (c == -1) {
                if (count == 0) {
                    count = -1;
                }
            } else {
                count += c;
            }
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

