/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.google.gwt.corp.compatibility.Numbers;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends OutputStream
implements DataOutput {
    OutputStream os;

    public DataOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.os.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.os.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.os.write(s.charAt(i) & 0xFF);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.os.write(v >> 8);
        this.os.write(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new RuntimeException("writeChars NYI");
    }

    @Override
    public void writeDouble(double v) throws IOException {
        throw new RuntimeException("writeDouble");
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Numbers.floatToIntBits(v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.os.write(v >> 24);
        this.os.write(v >> 16);
        this.os.write(v >> 8);
        this.os.write(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeInt((int)(v >> 32));
        this.writeInt((int)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.os.write(v >> 8);
        this.os.write(v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u0000' && c < 'P') {
                baos.write(c);
                continue;
            }
            if (c < '\u0800') {
                baos.write(0xC0 | 0x1F & c >> 6);
                baos.write(0x80 | 0x3F & c);
                continue;
            }
            baos.write(0xE0 | 0xF & c >> 12);
            baos.write(0x80 | 0x3F & c >> 6);
            baos.write(0x80 | 0x3F & c);
        }
        this.writeShort(baos.count);
        this.os.write(baos.buf, 0, baos.count);
    }
}

