/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import avian.Utf8;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    private final InputStream in;

    public InputStreamReader(InputStream in) {
        this.in = in;
    }

    public InputStreamReader(InputStream in, String encoding) throws UnsupportedEncodingException {
        this(in);
    }

    @Override
    public int read(char[] b, int offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        int c = this.in.read(buffer);
        if (c <= 0) {
            return c;
        }
        char[] buffer16 = Utf8.decode16(buffer, 0, c);
        System.arraycopy(buffer16, 0, b, offset, buffer16.length);
        return buffer16.length;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

