/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public abstract class Writer
implements Appendable,
Closeable,
Flushable {
    static final String TOKEN_NULL = "null";
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract void flush() throws IOException;

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] oneCharArray = new char[]{(char)oneChar};
            this.write(oneCharArray);
        }
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        if (count < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        char[] buf = new char[count];
        str.getChars(offset, offset + count, buf, 0);
        Object object = this.lock;
        synchronized (object) {
            this.write(buf, 0, buf.length);
        }
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (null == csq) {
            this.write(TOKEN_NULL);
        } else {
            this.write(((Object)csq).toString());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (null == csq) {
            this.write(TOKEN_NULL.substring(start, end));
        } else {
            this.write(((Object)csq.subSequence(start, end)).toString());
        }
        return this;
    }

    boolean checkError() {
        return false;
    }
}

