/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.CharToByteBufferAdapter;
import java.nio.DoubleBuffer;
import java.nio.DoubleToByteBufferAdapter;
import java.nio.FloatBuffer;
import java.nio.FloatToByteBufferAdapter;
import java.nio.IntBuffer;
import java.nio.IntToByteBufferAdapter;
import java.nio.LongBuffer;
import java.nio.LongToByteBufferAdapter;
import java.nio.ShortBuffer;
import java.nio.ShortToByteBufferAdapter;

abstract class BaseByteBuffer
extends ByteBuffer {
    protected BaseByteBuffer(int capacity) {
        super(capacity);
    }

    @Override
    public CharBuffer asCharBuffer() {
        return CharToByteBufferAdapter.wrap(this);
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        return DoubleToByteBufferAdapter.wrap(this);
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return FloatToByteBufferAdapter.wrap(this);
    }

    @Override
    public IntBuffer asIntBuffer() {
        return IntToByteBufferAdapter.wrap(this);
    }

    @Override
    public LongBuffer asLongBuffer() {
        return LongToByteBufferAdapter.wrap(this);
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return ShortToByteBufferAdapter.wrap(this);
    }

    @Override
    public final char getChar() {
        return (char)this.getShort();
    }

    @Override
    public final char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public final ByteBuffer putChar(char value) {
        return this.putShort((short)value);
    }

    @Override
    public final ByteBuffer putChar(int index, char value) {
        return this.putShort(index, (short)value);
    }
}

