/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

abstract class CharArrayBuffer
extends CharBuffer {
    protected final char[] backingArray;
    protected final int offset;

    CharArrayBuffer(char[] array) {
        this(array.length, array, 0);
    }

    CharArrayBuffer(int capacity) {
        this(capacity, new char[capacity], 0);
    }

    CharArrayBuffer(int capacity, char[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    @Override
    public final char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    @Override
    public final char get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.backingArray[this.offset + index];
    }

    @Override
    public final CharBuffer get(char[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dest, off, len);
        this.position += len;
        return this;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start < 0 || end < start || end > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        CharBuffer result = this.duplicate();
        result.limit(this.position + end);
        result.position(this.position + start);
        return result;
    }

    @Override
    public final String toString() {
        return String.copyValueOf(this.backingArray, this.offset + this.position, this.remaining());
    }
}

