/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.typedarrays.client.ArrayBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectReadOnlyFloatBufferAdapter;
import java.nio.DirectReadOnlyIntBufferAdapter;
import java.nio.DirectReadOnlyShortBufferAdapter;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

final class DirectReadOnlyByteBuffer
extends DirectByteBuffer {
    static DirectReadOnlyByteBuffer copy(DirectByteBuffer other, int markOfOther) {
        DirectReadOnlyByteBuffer buf = new DirectReadOnlyByteBuffer(other.byteArray.getBuffer(), other.capacity(), other.byteArray.getByteOffset());
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        buf.order(other.order());
        return buf;
    }

    DirectReadOnlyByteBuffer(ArrayBuffer backingArray, int capacity, int arrayOffset) {
        super(backingArray, capacity, arrayOffset);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return DirectReadOnlyByteBuffer.copy(this, this.mark);
    }

    @Override
    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer duplicate() {
        return DirectReadOnlyByteBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected byte[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return DirectReadOnlyFloatBufferAdapter.wrap(this);
    }

    @Override
    public IntBuffer asIntBuffer() {
        return this.order() == ByteOrder.nativeOrder() ? DirectReadOnlyIntBufferAdapter.wrap(this) : super.asIntBuffer();
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return this.order() == ByteOrder.nativeOrder() ? DirectReadOnlyShortBufferAdapter.wrap(this) : super.asShortBuffer();
    }

    @Override
    public ByteBuffer put(byte b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(int index, byte b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(byte[] src, int off, int len) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putDouble(double value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putDouble(int index, double value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putFloat(float value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putFloat(int index, float value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putInt(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putLong(long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putShort(int index, short value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putShort(short value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(ByteBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer slice() {
        DirectReadOnlyByteBuffer slice = new DirectReadOnlyByteBuffer(this.byteArray.getBuffer(), this.remaining(), this.byteArray.getByteOffset() + this.position);
        slice.order = this.order;
        return slice;
    }
}

