/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    public static LongBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newLongBuffer(capacity);
    }

    public static LongBuffer wrap(long[] array) {
        return LongBuffer.wrap(array, 0, array.length);
    }

    public static LongBuffer wrap(long[] array, int start, int len) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (start < 0 || len < 0 || (long)len + (long)start > (long)array.length) {
            throw new IndexOutOfBoundsException();
        }
        LongBuffer buf = BufferFactory.newLongBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    LongBuffer(int capacity) {
        super(capacity);
    }

    public final long[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract LongBuffer compact();

    @Override
    public int compareTo(LongBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            long otherLong;
            long thisLong = this.get(thisPos);
            if (thisLong != (otherLong = otherBuffer.get(otherPos))) {
                return thisLong < otherLong ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract LongBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof LongBuffer)) {
            return false;
        }
        LongBuffer otherBuffer = (LongBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract long get();

    public LongBuffer get(long[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public LongBuffer get(long[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)len + (long)off > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract long get(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            long l = this.get(myPosition++);
            hash = hash + (int)l ^ (int)(l >> 32);
        }
        return hash;
    }

    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract long[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract LongBuffer put(long var1);

    public final LongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public LongBuffer put(long[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)len + (long)off > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public LongBuffer put(LongBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        long[] contents = new long[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer slice();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(", status: capacity=");
        buf.append(this.capacity());
        buf.append(" position=");
        buf.append(this.position());
        buf.append(" limit=");
        buf.append(this.limit());
        return buf.toString();
    }
}

