/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.CharArrayBuffer;
import java.nio.CharBuffer;
import java.nio.ReadOnlyCharArrayBuffer;

final class ReadWriteCharArrayBuffer
extends CharArrayBuffer {
    static ReadWriteCharArrayBuffer copy(CharArrayBuffer other, int markOfOther) {
        ReadWriteCharArrayBuffer buf = new ReadWriteCharArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteCharArrayBuffer(char[] array) {
        super(array);
    }

    ReadWriteCharArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteCharArrayBuffer(int capacity, char[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return ReadOnlyCharArrayBuffer.copy(this, this.mark);
    }

    @Override
    public CharBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public CharBuffer duplicate() {
        return ReadWriteCharArrayBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected char[] protectedArray() {
        return this.backingArray;
    }

    @Override
    protected int protectedArrayOffset() {
        return this.offset;
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public CharBuffer put(char c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    @Override
    public CharBuffer put(int index, char c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.backingArray[this.offset + index] = c;
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)len + (long)off > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, off, this.backingArray, this.offset + this.position, len);
        this.position += len;
        return this;
    }

    @Override
    public CharBuffer slice() {
        return new ReadWriteCharArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

