/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.FloatArrayBuffer;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyFloatArrayBuffer;

final class ReadWriteFloatArrayBuffer
extends FloatArrayBuffer {
    static ReadWriteFloatArrayBuffer copy(FloatArrayBuffer other, int markOfOther) {
        ReadWriteFloatArrayBuffer buf = new ReadWriteFloatArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteFloatArrayBuffer(float[] array) {
        super(array);
    }

    ReadWriteFloatArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteFloatArrayBuffer(int capacity, float[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return ReadOnlyFloatArrayBuffer.copy(this, this.mark);
    }

    @Override
    public FloatBuffer compact() {
        int i = this.position + this.offset;
        int j = this.offset;
        for (int k = 0; k < this.remaining(); ++k) {
            this.backingArray[j] = this.backingArray[i];
            ++i;
            ++j;
        }
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public FloatBuffer duplicate() {
        return ReadWriteFloatArrayBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected float[] protectedArray() {
        return this.backingArray;
    }

    @Override
    protected int protectedArrayOffset() {
        return this.offset;
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public FloatBuffer put(float c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    @Override
    public FloatBuffer put(int index, float c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.backingArray[this.offset + index] = c;
        return this;
    }

    @Override
    public FloatBuffer put(float[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, off, this.backingArray, this.offset + this.position, len);
        this.position += len;
        return this;
    }

    @Override
    public FloatBuffer slice() {
        return new ReadWriteFloatArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

