/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.corp.compatibility.Numbers;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.HeapByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ReadOnlyHeapByteBuffer;

final class ReadWriteHeapByteBuffer
extends HeapByteBuffer {
    static ReadWriteHeapByteBuffer copy(HeapByteBuffer other, int markOfOther) {
        ReadWriteHeapByteBuffer buf = new ReadWriteHeapByteBuffer(other.backingArray, other.capacity(), other.offset);
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        buf.order(other.order());
        return buf;
    }

    ReadWriteHeapByteBuffer(byte[] backingArray) {
        super(backingArray);
    }

    ReadWriteHeapByteBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteHeapByteBuffer(byte[] backingArray, int capacity, int arrayOffset) {
        super(backingArray, capacity, arrayOffset);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return ReadOnlyHeapByteBuffer.copy(this, this.mark);
    }

    @Override
    public ByteBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer duplicate() {
        return ReadWriteHeapByteBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected byte[] protectedArray() {
        return this.backingArray;
    }

    @Override
    protected int protectedArrayOffset() {
        return this.offset;
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public ByteBuffer put(byte b) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = b;
        return this;
    }

    @Override
    public ByteBuffer put(int index, byte b) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.backingArray[this.offset + index] = b;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int off, int len) {
        if (off < 0 || len < 0 || (long)off + (long)len > (long)src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy(src, off, this.backingArray, this.offset + this.position, len);
        this.position += len;
        return this;
    }

    @Override
    public ByteBuffer putDouble(double value) {
        return this.putLong(Numbers.doubleToRawLongBits(value));
    }

    @Override
    public ByteBuffer putDouble(int index, double value) {
        return this.putLong(index, Numbers.doubleToRawLongBits(value));
    }

    @Override
    public ByteBuffer putFloat(float value) {
        return this.putInt(Numbers.floatToIntBits(value));
    }

    @Override
    public ByteBuffer putFloat(int index, float value) {
        return this.putInt(index, Numbers.floatToIntBits(value));
    }

    @Override
    public ByteBuffer putInt(int value) {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.store(this.position, value);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putInt(int index, int value) {
        if (index < 0 || (long)index + 4L > (long)this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.store(index, value);
        return this;
    }

    @Override
    public ByteBuffer putLong(int index, long value) {
        if (index < 0 || (long)index + 8L > (long)this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.store(index, value);
        return this;
    }

    @Override
    public ByteBuffer putLong(long value) {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.store(this.position, value);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putShort(int index, short value) {
        if (index < 0 || (long)index + 2L > (long)this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.store(index, value);
        return this;
    }

    @Override
    public ByteBuffer putShort(short value) {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.store(this.position, value);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer slice() {
        ReadWriteHeapByteBuffer slice = new ReadWriteHeapByteBuffer(this.backingArray, this.remaining(), this.offset + this.position);
        slice.order = this.order;
        return slice;
    }
}

