/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.ReadOnlyShortArrayBuffer;
import java.nio.ShortArrayBuffer;
import java.nio.ShortBuffer;

final class ReadWriteShortArrayBuffer
extends ShortArrayBuffer {
    static ReadWriteShortArrayBuffer copy(ShortArrayBuffer other, int markOfOther) {
        ReadWriteShortArrayBuffer buf = new ReadWriteShortArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteShortArrayBuffer(short[] array) {
        super(array);
    }

    ReadWriteShortArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteShortArrayBuffer(int capacity, short[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return ReadOnlyShortArrayBuffer.copy(this, this.mark);
    }

    @Override
    public ShortBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public ShortBuffer duplicate() {
        return ReadWriteShortArrayBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected short[] protectedArray() {
        return this.backingArray;
    }

    @Override
    protected int protectedArrayOffset() {
        return this.offset;
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public ShortBuffer put(short c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    @Override
    public ShortBuffer put(int index, short c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.backingArray[this.offset + index] = c;
        return this;
    }

    @Override
    public ShortBuffer put(short[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, off, this.backingArray, this.offset + this.position, len);
        this.position += len;
        return this;
    }

    @Override
    public ShortBuffer slice() {
        return new ReadWriteShortArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

