/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;

public class Collision {
    public static final int NULL_FEATURE = Integer.MAX_VALUE;
    private final IWorldPool pool;
    private final DistanceInput input = new DistanceInput();
    private final Distance.SimplexCache cache = new Distance.SimplexCache();
    private final DistanceOutput output = new DistanceOutput();
    private static Vec2 pA = new Vec2();
    private static Vec2 pB = new Vec2();
    private static Vec2 d = new Vec2();
    private static final Vec2 c = new Vec2();
    private static final Vec2 cLocal = new Vec2();
    private final Vec2 normal1 = new Vec2();
    private final Vec2 normal1World = new Vec2();
    private final Vec2 v1 = new Vec2();
    private final Vec2 v2 = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 dLocal1 = new Vec2();
    private final EdgeResults results1 = new EdgeResults();
    private final EdgeResults results2 = new EdgeResults();
    private final ClipVertex[] incidentEdge = new ClipVertex[2];
    private final Vec2 localTangent = new Vec2();
    private final Vec2 localNormal = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 tangent = new Vec2();
    private final Vec2 normal = new Vec2();
    private final Vec2 v11 = new Vec2();
    private final Vec2 v12 = new Vec2();
    private final ClipVertex[] clipPoints1 = new ClipVertex[2];
    private final ClipVertex[] clipPoints2 = new ClipVertex[2];
    private final Vec2 Q = new Vec2();
    private final Vec2 e = new Vec2();
    private final ContactID cf = new ContactID();
    private final Vec2 e1 = new Vec2();
    private final Vec2 P = new Vec2();
    private final Vec2 n = new Vec2();
    private final EPCollider collider = new EPCollider();

    public Collision(IWorldPool argPool) {
        this.incidentEdge[0] = new ClipVertex();
        this.incidentEdge[1] = new ClipVertex();
        this.clipPoints1[0] = new ClipVertex();
        this.clipPoints1[1] = new ClipVertex();
        this.clipPoints2[0] = new ClipVertex();
        this.clipPoints2[1] = new ClipVertex();
        this.pool = argPool;
    }

    public final boolean testOverlap(Shape shapeA, int indexA, Shape shapeB, int indexB, Transform xfA, Transform xfB) {
        this.input.proxyA.set(shapeA, indexA);
        this.input.proxyB.set(shapeB, indexB);
        this.input.transformA.set(xfA);
        this.input.transformB.set(xfB);
        this.input.useRadii = true;
        this.cache.count = 0;
        this.pool.getDistance().distance(this.output, this.cache, this.input);
        return this.output.distance < 1.1920929E-6f;
    }

    public static final void getPointStates(PointState[] state1, PointState[] state2, Manifold manifold1, Manifold manifold2) {
        int j;
        ContactID id;
        int i;
        for (i = 0; i < 2; ++i) {
            state1[i] = PointState.NULL_STATE;
            state2[i] = PointState.NULL_STATE;
        }
        block1: for (i = 0; i < manifold1.pointCount; ++i) {
            id = manifold1.points[i].id;
            state1[i] = PointState.REMOVE_STATE;
            for (j = 0; j < manifold2.pointCount; ++j) {
                if (!manifold2.points[j].id.isEqual(id)) continue;
                state1[i] = PointState.PERSIST_STATE;
                continue block1;
            }
        }
        block3: for (i = 0; i < manifold2.pointCount; ++i) {
            id = manifold2.points[i].id;
            state2[i] = PointState.ADD_STATE;
            for (j = 0; j < manifold1.pointCount; ++j) {
                if (!manifold1.points[j].id.isEqual(id)) continue;
                state2[i] = PointState.PERSIST_STATE;
                continue block3;
            }
        }
    }

    public static final int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vec2 normal, float offset, int vertexIndexA) {
        int numOut = 0;
        float distance0 = Vec2.dot(normal, vIn[0].v) - offset;
        float distance1 = Vec2.dot(normal, vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut++].set(vIn[0]);
        }
        if (distance1 <= 0.0f) {
            vOut[numOut++].set(vIn[1]);
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut].v.set(vIn[1].v).subLocal(vIn[0].v).mulLocal(interp).addLocal(vIn[0].v);
            vOut[numOut].id.indexA = (byte)vertexIndexA;
            vOut[numOut].id.indexB = vIn[0].id.indexB;
            vOut[numOut].id.typeA = (byte)ContactID.Type.VERTEX.ordinal();
            vOut[numOut].id.typeB = (byte)ContactID.Type.FACE.ordinal();
            ++numOut;
        }
        return numOut;
    }

    public final void collideCircles(Manifold manifold, CircleShape circle1, Transform xfA, CircleShape circle2, Transform xfB) {
        manifold.pointCount = 0;
        Transform.mulToOut(xfA, circle1.m_p, pA);
        Transform.mulToOut(xfB, circle2.m_p, pB);
        d.set(pB).subLocal(pA);
        float distSqr = Collision.d.x * Collision.d.x + Collision.d.y * Collision.d.y;
        float radius = circle1.m_radius + circle2.m_radius;
        if (distSqr > radius * radius) {
            return;
        }
        manifold.type = Manifold.ManifoldType.CIRCLES;
        manifold.localPoint.set(circle1.m_p);
        manifold.localNormal.setZero();
        manifold.pointCount = 1;
        manifold.points[0].localPoint.set(circle2.m_p);
        manifold.points[0].id.zero();
    }

    public final void collidePolygonAndCircle(Manifold manifold, PolygonShape polygon, Transform xfA, CircleShape circle, Transform xfB) {
        Vec2 normal;
        manifold.pointCount = 0;
        Transform.mulToOut(xfB, circle.m_p, c);
        Transform.mulTransToOut(xfA, c, cLocal);
        float cLocalx = Collision.cLocal.x;
        float cLocaly = Collision.cLocal.y;
        int normalIndex = 0;
        float separation = Float.MIN_VALUE;
        float radius = polygon.m_radius + circle.m_radius;
        int vertexCount = polygon.m_count;
        Vec2[] vertices = polygon.m_vertices;
        Vec2[] normals = polygon.m_normals;
        for (int i = 0; i < vertexCount; ++i) {
            Vec2 vertex = vertices[i];
            float tempx = cLocalx - vertex.x;
            float tempy = cLocaly - vertex.y;
            normal = normals[i];
            float s = normal.x * tempx + normal.y * tempy;
            if (s > radius) {
                return;
            }
            if (!(s > separation)) continue;
            separation = s;
            normalIndex = i;
        }
        int vertIndex1 = normalIndex;
        int vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
        Vec2 v1 = vertices[vertIndex1];
        Vec2 v2 = vertices[vertIndex2];
        if (separation < 1.1920929E-7f) {
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            normal = normals[normalIndex];
            manifold.localNormal.x = normal.x;
            manifold.localNormal.y = normal.y;
            manifold.localPoint.x = (v1.x + v2.x) * 0.5f;
            manifold.localPoint.y = (v1.y + v2.y) * 0.5f;
            ManifoldPoint mpoint = manifold.points[0];
            mpoint.localPoint.x = circle.m_p.x;
            mpoint.localPoint.y = circle.m_p.y;
            mpoint.id.zero();
            return;
        }
        float tempX = cLocalx - v1.x;
        float tempY = cLocaly - v1.y;
        float temp2X = v2.x - v1.x;
        float temp2Y = v2.y - v1.y;
        float u1 = tempX * temp2X + tempY * temp2Y;
        float temp3X = cLocalx - v2.x;
        float temp3Y = cLocaly - v2.y;
        float temp4X = v1.x - v2.x;
        float temp4Y = v1.y - v2.y;
        float u2 = temp3X * temp4X + temp3Y * temp4Y;
        if (u1 <= 0.0f) {
            float dx = cLocalx - v1.x;
            float dy = cLocaly - v1.y;
            if (dx * dx + dy * dy > radius * radius) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.x = cLocalx - v1.x;
            manifold.localNormal.y = cLocaly - v1.y;
            manifold.localNormal.normalize();
            manifold.localPoint.set(v1);
            manifold.points[0].localPoint.set(circle.m_p);
            manifold.points[0].id.zero();
        } else if (u2 <= 0.0f) {
            float dx = cLocalx - v2.x;
            float dy = cLocaly - v2.y;
            if (dx * dx + dy * dy > radius * radius) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.x = cLocalx - v2.x;
            manifold.localNormal.y = cLocaly - v2.y;
            manifold.localNormal.normalize();
            manifold.localPoint.set(v2);
            manifold.points[0].localPoint.set(circle.m_p);
            manifold.points[0].id.zero();
        } else {
            float fcx = (v1.x + v2.x) * 0.5f;
            float fcy = (v1.y + v2.y) * 0.5f;
            float tx = cLocalx - fcx;
            float ty = cLocaly - fcy;
            Vec2 normal2 = normals[vertIndex1];
            separation = tx * normal2.x + ty * normal2.y;
            if (separation > radius) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(normals[vertIndex1]);
            manifold.localPoint.x = fcx;
            manifold.localPoint.y = fcy;
            manifold.points[0].localPoint.set(circle.m_p);
            manifold.points[0].id.zero();
        }
    }

    public final float edgeSeparation(PolygonShape poly1, Transform xf1, int edge1, PolygonShape poly2, Transform xf2) {
        int count1 = poly1.m_count;
        Vec2[] vertices1 = poly1.m_vertices;
        Vec2[] normals1 = poly1.m_normals;
        int count2 = poly2.m_count;
        Vec2[] vertices2 = poly2.m_vertices;
        assert (0 <= edge1 && edge1 < count1);
        Rot.mulToOutUnsafe(xf1.q, normals1[edge1], this.normal1World);
        Rot.mulTransUnsafe(xf2.q, this.normal1World, this.normal1);
        float normal1x = this.normal1.x;
        float normal1y = this.normal1.y;
        float normal1Worldx = this.normal1World.x;
        float normal1Worldy = this.normal1World.y;
        int index = 0;
        float minDot = Float.MAX_VALUE;
        for (int i = 0; i < count2; ++i) {
            Vec2 a = vertices2[i];
            float dot = a.x * normal1x + a.y * normal1y;
            if (!(dot < minDot)) continue;
            minDot = dot;
            index = i;
        }
        Transform.mulToOut(xf1, vertices1[edge1], this.v1);
        Transform.mulToOut(xf2, vertices2[index], this.v2);
        float separation = Vec2.dot(this.v2.subLocal(this.v1), this.normal1World);
        return separation;
    }

    public final void findMaxSeparation(EdgeResults results, PolygonShape poly1, Transform xf1, PolygonShape poly2, Transform xf2) {
        float bestSeparation;
        int bestEdge;
        int increment;
        int count1 = poly1.m_count;
        Vec2[] normals1 = poly1.m_normals;
        Transform.mulToOutUnsafe(xf2, poly2.m_centroid, d);
        Transform.mulToOutUnsafe(xf1, poly1.m_centroid, this.temp);
        d.subLocal(this.temp);
        Rot.mulTransUnsafe(xf1.q, d, this.dLocal1);
        float dLocal1x = this.dLocal1.x;
        float dLocal1y = this.dLocal1.y;
        int edge = 0;
        float maxDot = Float.MIN_VALUE;
        for (int i = 0; i < count1; ++i) {
            Vec2 normal = normals1[i];
            float dot = normal.x * dLocal1x + normal.y * dLocal1y;
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            edge = i;
        }
        float s = this.edgeSeparation(poly1, xf1, edge, poly2, xf2);
        int prevEdge = edge - 1 >= 0 ? edge - 1 : count1 - 1;
        float sPrev = this.edgeSeparation(poly1, xf1, prevEdge, poly2, xf2);
        int nextEdge = edge + 1 < count1 ? edge + 1 : 0;
        float sNext = this.edgeSeparation(poly1, xf1, nextEdge, poly2, xf2);
        if (sPrev > s && sPrev > sNext) {
            increment = -1;
            bestEdge = prevEdge;
            bestSeparation = sPrev;
        } else if (sNext > s) {
            increment = 1;
            bestEdge = nextEdge;
            bestSeparation = sNext;
        } else {
            results.edgeIndex = edge;
            results.separation = s;
            return;
        }
        while ((s = this.edgeSeparation(poly1, xf1, edge = increment == -1 ? (bestEdge - 1 >= 0 ? bestEdge - 1 : count1 - 1) : (bestEdge + 1 < count1 ? bestEdge + 1 : 0), poly2, xf2)) > bestSeparation) {
            bestEdge = edge;
            bestSeparation = s;
        }
        results.edgeIndex = bestEdge;
        results.separation = bestSeparation;
    }

    public final void findIncidentEdge(ClipVertex[] c, PolygonShape poly1, Transform xf1, int edge1, PolygonShape poly2, Transform xf2) {
        int count1 = poly1.m_count;
        Vec2[] normals1 = poly1.m_normals;
        int count2 = poly2.m_count;
        Vec2[] vertices2 = poly2.m_vertices;
        Vec2[] normals2 = poly2.m_normals;
        assert (0 <= edge1 && edge1 < count1);
        Rot.mulToOutUnsafe(xf1.q, normals1[edge1], this.normal1);
        Rot.mulTrans(xf2.q, this.normal1, this.normal1);
        int index = 0;
        float minDot = Float.MAX_VALUE;
        for (int i = 0; i < count2; ++i) {
            float dot = Vec2.dot(this.normal1, normals2[i]);
            if (!(dot < minDot)) continue;
            minDot = dot;
            index = i;
        }
        int i1 = index;
        int i2 = i1 + 1 < count2 ? i1 + 1 : 0;
        Transform.mulToOutUnsafe(xf2, vertices2[i1], c[0].v);
        c[0].id.indexA = (byte)edge1;
        c[0].id.indexB = (byte)i1;
        c[0].id.typeA = (byte)ContactID.Type.FACE.ordinal();
        c[0].id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
        Transform.mulToOutUnsafe(xf2, vertices2[i2], c[1].v);
        c[1].id.indexA = (byte)edge1;
        c[1].id.indexB = (byte)i2;
        c[1].id.typeA = (byte)ContactID.Type.FACE.ordinal();
        c[1].id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
    }

    public final void collidePolygons(Manifold manifold, PolygonShape polyA, Transform xfA, PolygonShape polyB, Transform xfB) {
        boolean flip;
        int edge1;
        Transform xf2;
        Transform xf1;
        PolygonShape poly2;
        PolygonShape poly1;
        manifold.pointCount = 0;
        float totalRadius = polyA.m_radius + polyB.m_radius;
        this.findMaxSeparation(this.results1, polyA, xfA, polyB, xfB);
        if (this.results1.separation > totalRadius) {
            return;
        }
        this.findMaxSeparation(this.results2, polyB, xfB, polyA, xfA);
        if (this.results2.separation > totalRadius) {
            return;
        }
        float k_relativeTol = 0.98f;
        float k_absoluteTol = 0.001f;
        if (this.results2.separation > 0.98f * this.results1.separation + 0.001f) {
            poly1 = polyB;
            poly2 = polyA;
            xf1 = xfB;
            xf2 = xfA;
            edge1 = this.results2.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_B;
            flip = true;
        } else {
            poly1 = polyA;
            poly2 = polyB;
            xf1 = xfA;
            xf2 = xfB;
            edge1 = this.results1.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_A;
            flip = false;
        }
        this.findIncidentEdge(this.incidentEdge, poly1, xf1, edge1, poly2, xf2);
        int count1 = poly1.m_count;
        Vec2[] vertices1 = poly1.m_vertices;
        int iv1 = edge1;
        int iv2 = edge1 + 1 < count1 ? edge1 + 1 : 0;
        this.v11.set(vertices1[iv1]);
        this.v12.set(vertices1[iv2]);
        this.localTangent.set(this.v12).subLocal(this.v11);
        this.localTangent.normalize();
        Vec2.crossToOutUnsafe(this.localTangent, 1.0f, this.localNormal);
        this.planePoint.set(this.v11).addLocal(this.v12).mulLocal(0.5f);
        Rot.mulToOutUnsafe(xf1.q, this.localTangent, this.tangent);
        Vec2.crossToOutUnsafe(this.tangent, 1.0f, this.normal);
        Transform.mulToOut(xf1, this.v11, this.v11);
        Transform.mulToOut(xf1, this.v12, this.v12);
        float frontOffset = Vec2.dot(this.normal, this.v11);
        float sideOffset1 = -Vec2.dot(this.tangent, this.v11) + totalRadius;
        float sideOffset2 = Vec2.dot(this.tangent, this.v12) + totalRadius;
        this.tangent.negateLocal();
        int np = Collision.clipSegmentToLine(this.clipPoints1, this.incidentEdge, this.tangent, sideOffset1, iv1);
        this.tangent.negateLocal();
        if (np < 2) {
            return;
        }
        np = Collision.clipSegmentToLine(this.clipPoints2, this.clipPoints1, this.tangent, sideOffset2, iv2);
        if (np < 2) {
            return;
        }
        manifold.localNormal.set(this.localNormal);
        manifold.localPoint.set(this.planePoint);
        int pointCount = 0;
        for (int i = 0; i < 2; ++i) {
            float separation = Vec2.dot(this.normal, this.clipPoints2[i].v) - frontOffset;
            if (!(separation <= totalRadius)) continue;
            ManifoldPoint cp = manifold.points[pointCount];
            Transform.mulTransToOut(xf2, this.clipPoints2[i].v, cp.localPoint);
            cp.id.set(this.clipPoints2[i].id);
            if (flip) {
                cp.id.flip();
            }
            ++pointCount;
        }
        manifold.pointCount = pointCount;
    }

    public void collideEdgeAndCircle(Manifold manifold, EdgeShape edgeA, Transform xfA, CircleShape circleB, Transform xfB) {
        manifold.pointCount = 0;
        Transform.mulToOutUnsafe(xfB, circleB.m_p, this.temp);
        Transform.mulTransToOutUnsafe(xfA, this.temp, this.Q);
        Vec2 A2 = edgeA.m_vertex1;
        Vec2 B2 = edgeA.m_vertex2;
        this.e.set(B2).subLocal(A2);
        float u = Vec2.dot(this.e, this.temp.set(B2).subLocal(this.Q));
        float v = Vec2.dot(this.e, this.temp.set(this.Q).subLocal(A2));
        float radius = edgeA.m_radius + circleB.m_radius;
        this.cf.indexB = 0;
        this.cf.typeB = (byte)ContactID.Type.VERTEX.ordinal();
        if (v <= 0.0f) {
            Vec2 P = A2;
            d.set(this.Q).subLocal(P);
            float dd = Vec2.dot(d, d);
            if (dd > radius * radius) {
                return;
            }
            if (edgeA.m_hasVertex0) {
                Vec2 A1 = edgeA.m_vertex0;
                Vec2 B1 = A2;
                this.e1.set(B1).subLocal(A1);
                float u1 = Vec2.dot(this.e1, this.temp.set(B1).subLocal(this.Q));
                if (u1 > 0.0f) {
                    return;
                }
            }
            this.cf.indexA = 0;
            this.cf.typeA = (byte)ContactID.Type.VERTEX.ordinal();
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.CIRCLES;
            manifold.localNormal.setZero();
            manifold.localPoint.set(P);
            manifold.points[0].id.set(this.cf);
            manifold.points[0].localPoint.set(circleB.m_p);
            return;
        }
        if (u <= 0.0f) {
            Vec2 P = B2;
            d.set(this.Q).subLocal(P);
            float dd = Vec2.dot(d, d);
            if (dd > radius * radius) {
                return;
            }
            if (edgeA.m_hasVertex3) {
                Vec2 B22 = edgeA.m_vertex3;
                Vec2 A22 = B2;
                Vec2 e2 = this.e1;
                e2.set(B22).subLocal(A22);
                float v2 = Vec2.dot(e2, this.temp.set(this.Q).subLocal(A22));
                if (v2 > 0.0f) {
                    return;
                }
            }
            this.cf.indexA = 1;
            this.cf.typeA = (byte)ContactID.Type.VERTEX.ordinal();
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.CIRCLES;
            manifold.localNormal.setZero();
            manifold.localPoint.set(P);
            manifold.points[0].id.set(this.cf);
            manifold.points[0].localPoint.set(circleB.m_p);
            return;
        }
        float den = Vec2.dot(this.e, this.e);
        assert (den > 0.0f);
        this.P.set(A2).mulLocal(u).addLocal(this.temp.set(B2).mulLocal(v));
        this.P.mulLocal(1.0f / den);
        d.set(this.Q).subLocal(this.P);
        float dd = Vec2.dot(d, d);
        if (dd > radius * radius) {
            return;
        }
        this.n.x = -this.e.y;
        this.n.y = this.e.x;
        if (Vec2.dot(this.n, this.temp.set(this.Q).subLocal(A2)) < 0.0f) {
            this.n.set(-this.n.x, -this.n.y);
        }
        this.n.normalize();
        this.cf.indexA = 0;
        this.cf.typeA = (byte)ContactID.Type.FACE.ordinal();
        manifold.pointCount = 1;
        manifold.type = Manifold.ManifoldType.FACE_A;
        manifold.localNormal.set(this.n);
        manifold.localPoint.set(A2);
        manifold.points[0].id.set(this.cf);
        manifold.points[0].localPoint.set(circleB.m_p);
    }

    public void collideEdgeAndPolygon(Manifold manifold, EdgeShape edgeA, Transform xfA, PolygonShape polygonB, Transform xfB) {
        this.collider.collide(manifold, edgeA, xfA, polygonB, xfB);
    }

    static class EPCollider {
        final TempPolygon m_polygonB = new TempPolygon();
        final Transform m_xf = new Transform();
        final Vec2 m_centroidB = new Vec2();
        Vec2 m_v0 = new Vec2();
        Vec2 m_v1 = new Vec2();
        Vec2 m_v2 = new Vec2();
        Vec2 m_v3 = new Vec2();
        final Vec2 m_normal0 = new Vec2();
        final Vec2 m_normal1 = new Vec2();
        final Vec2 m_normal2 = new Vec2();
        final Vec2 m_normal = new Vec2();
        VertexType m_type1;
        VertexType m_type2;
        final Vec2 m_lowerLimit = new Vec2();
        final Vec2 m_upperLimit = new Vec2();
        float m_radius;
        boolean m_front;
        private final Vec2 edge1 = new Vec2();
        private final Vec2 temp = new Vec2();
        private final Vec2 edge0 = new Vec2();
        private final Vec2 edge2 = new Vec2();
        private final ClipVertex[] ie = new ClipVertex[2];
        private final ClipVertex[] clipPoints1 = new ClipVertex[2];
        private final ClipVertex[] clipPoints2 = new ClipVertex[2];
        private final ReferenceFace rf = new ReferenceFace();
        private final EPAxis edgeAxis = new EPAxis();
        private final EPAxis polygonAxis = new EPAxis();
        private final Vec2 perp = new Vec2();
        private final Vec2 n = new Vec2();

        public EPCollider() {
            for (int i = 0; i < 2; ++i) {
                this.ie[i] = new ClipVertex();
                this.clipPoints1[i] = new ClipVertex();
                this.clipPoints2[i] = new ClipVertex();
            }
        }

        public void collide(Manifold manifold, EdgeShape edgeA, Transform xfA, PolygonShape polygonB, Transform xfB) {
            int i;
            Transform.mulTransToOutUnsafe(xfA, xfB, this.m_xf);
            Transform.mulToOutUnsafe(this.m_xf, polygonB.m_centroid, this.m_centroidB);
            this.m_v0 = edgeA.m_vertex0;
            this.m_v1 = edgeA.m_vertex1;
            this.m_v2 = edgeA.m_vertex2;
            this.m_v3 = edgeA.m_vertex3;
            boolean hasVertex0 = edgeA.m_hasVertex0;
            boolean hasVertex3 = edgeA.m_hasVertex3;
            this.edge1.set(this.m_v2).subLocal(this.m_v1);
            this.edge1.normalize();
            this.m_normal1.set(this.edge1.y, -this.edge1.x);
            float offset1 = Vec2.dot(this.m_normal1, this.temp.set(this.m_centroidB).subLocal(this.m_v1));
            float offset0 = 0.0f;
            float offset2 = 0.0f;
            boolean convex1 = false;
            boolean convex2 = false;
            if (hasVertex0) {
                this.edge0.set(this.m_v1).subLocal(this.m_v0);
                this.edge0.normalize();
                this.m_normal0.set(this.edge0.y, -this.edge0.x);
                convex1 = Vec2.cross(this.edge0, this.edge1) >= 0.0f;
                offset0 = Vec2.dot(this.m_normal0, this.temp.set(this.m_centroidB).subLocal(this.m_v0));
            }
            if (hasVertex3) {
                this.edge2.set(this.m_v3).subLocal(this.m_v2);
                this.edge2.normalize();
                this.m_normal2.set(this.edge2.y, -this.edge2.x);
                convex2 = Vec2.cross(this.edge1, this.edge2) > 0.0f;
                offset2 = Vec2.dot(this.m_normal2, this.temp.set(this.m_centroidB).subLocal(this.m_v2));
            }
            if (hasVertex0 && hasVertex3) {
                if (convex1 && convex2) {
                    boolean bl = this.m_front = offset0 >= 0.0f || offset1 >= 0.0f || offset2 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal0);
                        this.m_upperLimit.set(this.m_normal2);
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal1).negateLocal();
                        this.m_upperLimit.set(this.m_normal1).negateLocal();
                    }
                } else if (convex1) {
                    boolean bl = this.m_front = offset0 >= 0.0f || offset1 >= 0.0f && offset2 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal0);
                        this.m_upperLimit.set(this.m_normal1);
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal2).negateLocal();
                        this.m_upperLimit.set(this.m_normal1).negateLocal();
                    }
                } else if (convex2) {
                    boolean bl = this.m_front = offset2 >= 0.0f || offset0 >= 0.0f && offset1 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal1);
                        this.m_upperLimit.set(this.m_normal2);
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal1).negateLocal();
                        this.m_upperLimit.set(this.m_normal0).negateLocal();
                    }
                } else {
                    boolean bl = this.m_front = offset0 >= 0.0f && offset1 >= 0.0f && offset2 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal1);
                        this.m_upperLimit.set(this.m_normal1);
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal2).negateLocal();
                        this.m_upperLimit.set(this.m_normal0).negateLocal();
                    }
                }
            } else if (hasVertex0) {
                if (convex1) {
                    boolean bl = this.m_front = offset0 >= 0.0f || offset1 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal0);
                        this.m_upperLimit.set(this.m_normal1).negateLocal();
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal1);
                        this.m_upperLimit.set(this.m_normal1).negateLocal();
                    }
                } else {
                    boolean bl = this.m_front = offset0 >= 0.0f && offset1 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal1);
                        this.m_upperLimit.set(this.m_normal1).negateLocal();
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal1);
                        this.m_upperLimit.set(this.m_normal0).negateLocal();
                    }
                }
            } else if (hasVertex3) {
                if (convex2) {
                    boolean bl = this.m_front = offset1 >= 0.0f || offset2 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal1).negateLocal();
                        this.m_upperLimit.set(this.m_normal2);
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal1).negateLocal();
                        this.m_upperLimit.set(this.m_normal1);
                    }
                } else {
                    boolean bl = this.m_front = offset1 >= 0.0f && offset2 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.set(this.m_normal1);
                        this.m_lowerLimit.set(this.m_normal1).negateLocal();
                        this.m_upperLimit.set(this.m_normal1);
                    } else {
                        this.m_normal.set(this.m_normal1).negateLocal();
                        this.m_lowerLimit.set(this.m_normal2).negateLocal();
                        this.m_upperLimit.set(this.m_normal1);
                    }
                }
            } else {
                boolean bl = this.m_front = offset1 >= 0.0f;
                if (this.m_front) {
                    this.m_normal.set(this.m_normal1);
                    this.m_lowerLimit.set(this.m_normal1).negateLocal();
                    this.m_upperLimit.set(this.m_normal1).negateLocal();
                } else {
                    this.m_normal.set(this.m_normal1).negateLocal();
                    this.m_lowerLimit.set(this.m_normal1);
                    this.m_upperLimit.set(this.m_normal1);
                }
            }
            this.m_polygonB.count = polygonB.m_count;
            for (int i2 = 0; i2 < polygonB.m_count; ++i2) {
                Transform.mulToOutUnsafe(this.m_xf, polygonB.m_vertices[i2], this.m_polygonB.vertices[i2]);
                Rot.mulToOutUnsafe(this.m_xf.q, polygonB.m_normals[i2], this.m_polygonB.normals[i2]);
            }
            this.m_radius = 0.02f;
            manifold.pointCount = 0;
            this.computeEdgeSeparation(this.edgeAxis);
            if (this.edgeAxis.type == EPAxis.Type.UNKNOWN) {
                return;
            }
            if (this.edgeAxis.separation > this.m_radius) {
                return;
            }
            this.computePolygonSeparation(this.polygonAxis);
            if (this.polygonAxis.type != EPAxis.Type.UNKNOWN && this.polygonAxis.separation > this.m_radius) {
                return;
            }
            float k_relativeTol = 0.98f;
            float k_absoluteTol = 0.001f;
            EPAxis primaryAxis = this.polygonAxis.type == EPAxis.Type.UNKNOWN ? this.edgeAxis : (this.polygonAxis.separation > 0.98f * this.edgeAxis.separation + 0.001f ? this.polygonAxis : this.edgeAxis);
            if (primaryAxis.type == EPAxis.Type.EDGE_A) {
                manifold.type = Manifold.ManifoldType.FACE_A;
                int bestIndex = 0;
                float bestValue = Vec2.dot(this.m_normal, this.m_polygonB.normals[0]);
                for (i = 1; i < this.m_polygonB.count; ++i) {
                    float value = Vec2.dot(this.m_normal, this.m_polygonB.normals[i]);
                    if (!(value < bestValue)) continue;
                    bestValue = value;
                    bestIndex = i;
                }
                int i1 = bestIndex;
                int i2 = i1 + 1 < this.m_polygonB.count ? i1 + 1 : 0;
                this.ie[0].v.set(this.m_polygonB.vertices[i1]);
                this.ie[0].id.indexA = 0;
                this.ie[0].id.indexB = (byte)i1;
                this.ie[0].id.typeA = (byte)ContactID.Type.FACE.ordinal();
                this.ie[0].id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
                this.ie[1].v.set(this.m_polygonB.vertices[i2]);
                this.ie[1].id.indexA = 0;
                this.ie[1].id.indexB = (byte)i2;
                this.ie[1].id.typeA = (byte)ContactID.Type.FACE.ordinal();
                this.ie[1].id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
                if (this.m_front) {
                    this.rf.i1 = 0;
                    this.rf.i2 = 1;
                    this.rf.v1.set(this.m_v1);
                    this.rf.v2.set(this.m_v2);
                    this.rf.normal.set(this.m_normal1);
                } else {
                    this.rf.i1 = 1;
                    this.rf.i2 = 0;
                    this.rf.v1.set(this.m_v2);
                    this.rf.v2.set(this.m_v1);
                    this.rf.normal.set(this.m_normal1).negateLocal();
                }
            } else {
                manifold.type = Manifold.ManifoldType.FACE_B;
                this.ie[0].v.set(this.m_v1);
                this.ie[0].id.indexA = 0;
                this.ie[0].id.indexB = (byte)primaryAxis.index;
                this.ie[0].id.typeA = (byte)ContactID.Type.VERTEX.ordinal();
                this.ie[0].id.typeB = (byte)ContactID.Type.FACE.ordinal();
                this.ie[1].v.set(this.m_v2);
                this.ie[1].id.indexA = 0;
                this.ie[1].id.indexB = (byte)primaryAxis.index;
                this.ie[1].id.typeA = (byte)ContactID.Type.VERTEX.ordinal();
                this.ie[1].id.typeB = (byte)ContactID.Type.FACE.ordinal();
                this.rf.i1 = primaryAxis.index;
                this.rf.i2 = this.rf.i1 + 1 < this.m_polygonB.count ? this.rf.i1 + 1 : 0;
                this.rf.v1.set(this.m_polygonB.vertices[this.rf.i1]);
                this.rf.v2.set(this.m_polygonB.vertices[this.rf.i2]);
                this.rf.normal.set(this.m_polygonB.normals[this.rf.i1]);
            }
            this.rf.sideNormal1.set(this.rf.normal.y, -this.rf.normal.x);
            this.rf.sideNormal2.set(this.rf.sideNormal1).negateLocal();
            this.rf.sideOffset1 = Vec2.dot(this.rf.sideNormal1, this.rf.v1);
            this.rf.sideOffset2 = Vec2.dot(this.rf.sideNormal2, this.rf.v2);
            int np = Collision.clipSegmentToLine(this.clipPoints1, this.ie, this.rf.sideNormal1, this.rf.sideOffset1, this.rf.i1);
            if (np < 2) {
                return;
            }
            np = Collision.clipSegmentToLine(this.clipPoints2, this.clipPoints1, this.rf.sideNormal2, this.rf.sideOffset2, this.rf.i2);
            if (np < 2) {
                return;
            }
            if (primaryAxis.type == EPAxis.Type.EDGE_A) {
                manifold.localNormal.set(this.rf.normal);
                manifold.localPoint.set(this.rf.v1);
            } else {
                manifold.localNormal.set(polygonB.m_normals[this.rf.i1]);
                manifold.localPoint.set(polygonB.m_vertices[this.rf.i1]);
            }
            int pointCount = 0;
            for (i = 0; i < 2; ++i) {
                float separation = Vec2.dot(this.rf.normal, this.temp.set(this.clipPoints2[i].v).subLocal(this.rf.v1));
                if (!(separation <= this.m_radius)) continue;
                ManifoldPoint cp = manifold.points[pointCount];
                if (primaryAxis.type == EPAxis.Type.EDGE_A) {
                    Transform.mulTransToOutUnsafe(this.m_xf, this.clipPoints2[i].v, cp.localPoint);
                    cp.id.set(this.clipPoints2[i].id);
                } else {
                    cp.localPoint.set(this.clipPoints2[i].v);
                    cp.id.typeA = this.clipPoints2[i].id.typeB;
                    cp.id.typeB = this.clipPoints2[i].id.typeA;
                    cp.id.indexA = this.clipPoints2[i].id.indexB;
                    cp.id.indexB = this.clipPoints2[i].id.indexA;
                }
                ++pointCount;
            }
            manifold.pointCount = pointCount;
        }

        public void computeEdgeSeparation(EPAxis axis) {
            axis.type = EPAxis.Type.EDGE_A;
            axis.index = this.m_front ? 0 : 1;
            axis.separation = Float.MAX_VALUE;
            for (int i = 0; i < this.m_polygonB.count; ++i) {
                float s = Vec2.dot(this.m_normal, this.temp.set(this.m_polygonB.vertices[i]).subLocal(this.m_v1));
                if (!(s < axis.separation)) continue;
                axis.separation = s;
            }
        }

        public void computePolygonSeparation(EPAxis axis) {
            axis.type = EPAxis.Type.UNKNOWN;
            axis.index = -1;
            axis.separation = Float.MIN_VALUE;
            this.perp.set(-this.m_normal.y, this.m_normal.x);
            for (int i = 0; i < this.m_polygonB.count; ++i) {
                this.n.set(this.m_polygonB.normals[i]).negateLocal();
                float s1 = Vec2.dot(this.n, this.temp.set(this.m_polygonB.vertices[i]).subLocal(this.m_v1));
                float s2 = Vec2.dot(this.n, this.temp.set(this.m_polygonB.vertices[i]).subLocal(this.m_v2));
                float s = MathUtils.min(s1, s2);
                if (s > this.m_radius) {
                    axis.type = EPAxis.Type.EDGE_B;
                    axis.index = i;
                    axis.separation = s;
                    return;
                }
                if ((!(Vec2.dot(this.n, this.perp) >= 0.0f) ? Vec2.dot(this.temp.set(this.n).subLocal(this.m_lowerLimit), this.m_normal) < -0.03490659f : Vec2.dot(this.temp.set(this.n).subLocal(this.m_upperLimit), this.m_normal) < -0.03490659f) || !(s > axis.separation)) continue;
                axis.type = EPAxis.Type.EDGE_B;
                axis.index = i;
                axis.separation = s;
            }
        }

        static enum VertexType {
            ISOLATED,
            CONCAVE,
            CONVEX;

        }
    }

    static class ReferenceFace {
        int i1;
        int i2;
        final Vec2 v1 = new Vec2();
        final Vec2 v2 = new Vec2();
        final Vec2 normal = new Vec2();
        final Vec2 sideNormal1 = new Vec2();
        float sideOffset1;
        final Vec2 sideNormal2 = new Vec2();
        float sideOffset2;

        ReferenceFace() {
        }
    }

    static class TempPolygon {
        final Vec2[] vertices = new Vec2[8];
        final Vec2[] normals = new Vec2[8];
        int count;

        public TempPolygon() {
            for (int i = 0; i < this.vertices.length; ++i) {
                this.vertices[i] = new Vec2();
                this.normals[i] = new Vec2();
            }
        }
    }

    static class EPAxis {
        Type type;
        int index;
        float separation;

        EPAxis() {
        }

        static enum Type {
            UNKNOWN,
            EDGE_A,
            EDGE_B;

        }
    }

    public static enum PointState {
        NULL_STATE,
        ADD_STATE,
        PERSIST_STATE,
        REMOVE_STATE;

    }

    public static class ClipVertex {
        public final Vec2 v = new Vec2();
        public final ContactID id = new ContactID();

        public void set(ClipVertex cv) {
            this.v.set(cv.v);
            this.id.set(cv.id);
        }
    }

    private static class EdgeResults {
        public float separation;
        public int edgeIndex;

        private EdgeResults() {
        }
    }
}

