/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import org.jbox2d.pooling.IDynamicStack;
import org.jbox2d.pooling.normal.Generator;

public class MutableStack<E, T extends E>
implements IDynamicStack<E> {
    private Object[] stack;
    private int index = 0;
    private int size;
    private final Generator<T> gen;

    public MutableStack(Generator<T> gen, int argInitSize) {
        this.gen = gen;
        this.stack = null;
        this.index = 0;
        this.extendStack(argInitSize);
    }

    private void extendStack(int argSize) {
        Object[] newStack = new Object[argSize];
        if (this.stack != null) {
            System.arraycopy(this.stack, 0, newStack, 0, this.size);
        }
        for (int i = 0; i < newStack.length; ++i) {
            newStack[i] = this.gen.gen();
        }
        this.stack = newStack;
        this.size = newStack.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack(this.size * 2);
        }
        return (E)this.stack[this.index++];
    }

    @Override
    public final void push(E argObject) {
        assert (this.index > 0);
        this.stack[--this.index] = argObject;
    }
}

