/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model.skeleton;

import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.model.AnimatedModel;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;

public class SkeletonModel
implements AnimatedModel {
    public final Skeleton skeleton;
    public final SkeletonSubMesh[] subMeshes;
    final Vector3 v = new Vector3();
    protected SkeletonAnimation[] animations;
    private static final BoundingBox tmpBox = new BoundingBox();

    public SkeletonModel(Skeleton skeleton, SubMesh[] subMeshes) {
        this.skeleton = skeleton;
        this.subMeshes = new SkeletonSubMesh[subMeshes.length];
        for (int i = 0; i < subMeshes.length; ++i) {
            this.subMeshes[i] = (SkeletonSubMesh)subMeshes[i];
        }
        this.setMaterial(new Material("default", new MaterialAttribute[0]));
    }

    public void setBindPose() {
        this.skeleton.setBindPose();
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.skin(this.subMeshes[i], this.skeleton.combinedMatrices);
        }
    }

    @Override
    public void setAnimation(String animation, float time, boolean loop) {
        this.skeleton.setAnimation(animation, time);
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.skin(this.subMeshes[i], this.skeleton.combinedMatrices);
        }
    }

    public void skin(SkeletonSubMesh subMesh, Array<Matrix4> boneMatrices) {
        int stride = subMesh.mesh.getVertexSize() / 4;
        int numVertices = subMesh.mesh.getNumVertices();
        int idx = 0;
        int nidx = subMesh.mesh.getVertexAttribute(2) == null ? -1 : subMesh.mesh.getVertexAttribute((int)2).offset / 4;
        float[] vertices = subMesh.vertices;
        float[] skinnedVertices = subMesh.skinnedVertices;
        System.arraycopy(subMesh.vertices, 0, skinnedVertices, 0, subMesh.vertices.length);
        int i = 0;
        while (i < numVertices) {
            int[] boneIndices = subMesh.boneAssignments[i];
            float[] boneWeights = subMesh.boneWeights[i];
            float ox = vertices[idx];
            float oy = vertices[idx + 1];
            float oz = vertices[idx + 2];
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float onx = 0.0f;
            float ony = 0.0f;
            float onz = 0.0f;
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            if (nidx != -1) {
                onx = vertices[nidx];
                ony = vertices[nidx + 1];
                onz = vertices[nidx + 2];
            }
            for (int j = 0; j < boneIndices.length; ++j) {
                int boneIndex = boneIndices[j];
                float weight = boneWeights[j];
                this.v.set(ox, oy, oz);
                this.v.mul(boneMatrices.get(boneIndex));
                x += this.v.x * weight;
                y += this.v.y * weight;
                z += this.v.z * weight;
                if (nidx == -1) continue;
                this.v.set(onx, ony, onz);
                this.v.rot(boneMatrices.get(boneIndex));
                nx += this.v.x * weight;
                ny += this.v.y * weight;
                nz += this.v.z * weight;
            }
            skinnedVertices[idx] = x;
            skinnedVertices[idx + 1] = y;
            skinnedVertices[idx + 2] = z;
            if (nidx != -1) {
                skinnedVertices[nidx] = nx;
                skinnedVertices[nidx + 1] = ny;
                skinnedVertices[nidx + 2] = nz;
            }
            ++i;
            idx += stride;
            nidx += stride;
        }
        subMesh.mesh.setVertices(skinnedVertices);
    }

    @Override
    public void render() {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            SkeletonSubMesh subMesh = this.subMeshes[i];
            if (i == 0) {
                subMesh.material.bind();
            } else if (!this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind();
            }
            subMesh.mesh.render(subMesh.primitiveType);
        }
    }

    @Override
    public void render(ShaderProgram program) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            SkeletonSubMesh subMesh = this.subMeshes[i];
            if (i == 0) {
                subMesh.material.bind(program);
            } else if (!this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind(program);
            }
            subMesh.mesh.render(program, subMesh.primitiveType);
        }
    }

    @Override
    public void setMaterials(Material ... materials) {
        if (materials.length != this.subMeshes.length) {
            throw new UnsupportedOperationException("number of materials must equal number of sub-meshes");
        }
        for (Material this.subMeshes[i].material : materials) {
        }
    }

    @Override
    public void setMaterial(Material material) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            this.subMeshes[i].material = material;
        }
    }

    @Override
    public SubMesh getSubMesh(String name) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            if (!this.subMeshes[i].name.equals(name)) continue;
            return this.subMeshes[i];
        }
        return null;
    }

    @Override
    public SubMesh[] getSubMeshes() {
        return this.subMeshes;
    }

    @Override
    public SkeletonAnimation getAnimation(String name) {
        return this.skeleton.animations.get(name);
    }

    public SkeletonAnimation[] getAnimations() {
        if (this.animations == null || this.animations.length != this.skeleton.animations.size) {
            this.animations = new SkeletonAnimation[this.skeleton.animations.size];
            int i = 0;
            for (SkeletonAnimation anim : this.skeleton.animations.values()) {
                this.animations[i++] = anim;
            }
        }
        return this.animations;
    }

    @Override
    public Model getSubModel(String ... subMeshNames) {
        return null;
    }

    @Override
    public void getBoundingBox(BoundingBox bbox) {
        bbox.inf();
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.subMeshes[i].mesh.calculateBoundingBox(tmpBox);
            bbox.ext(tmpBox);
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.subMeshes[i].mesh.dispose();
        }
    }
}

