import _objectSpread from"@babel/runtime/helpers/objectSpread";import NavigationStateUtils from'../StateUtils';var routeName='Anything';describe('StateUtils',function(){it('gets route',function(){var state={index:0,routes:[{key:'a',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.get(state,'a')).toEqual({key:'a',routeName:routeName});expect(NavigationStateUtils.get(state,'b')).toBe(null);});it('gets route index',function(){var state={index:1,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.indexOf(state,'a')).toBe(0);expect(NavigationStateUtils.indexOf(state,'b')).toBe(1);expect(NavigationStateUtils.indexOf(state,'c')).toBe(-1);});it('has a route',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.has(state,'b')).toBe(true);expect(NavigationStateUtils.has(state,'c')).toBe(false);});it('pushes a route',function(){var state={index:0,routes:[{key:'a',routeName:routeName}],isTransitioning:false};var newState={index:1,isTransitioning:false,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}]};expect(NavigationStateUtils.push(state,{key:'b',routeName:routeName})).toEqual(newState);});it('does not push duplicated route',function(){var state={index:0,routes:[{key:'a',routeName:routeName}],isTransitioning:false};expect(function(){return NavigationStateUtils.push(state,{key:'a',routeName:routeName});}).toThrow('should not push route with duplicated key a');});it('pops route',function(){var state={index:1,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:0,routes:[{key:'a',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.pop(state)).toEqual(newState);});it('does not pop route if not applicable',function(){var state={index:0,routes:[{key:'a',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.pop(state)).toBe(state);});it('jumps to new index',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:1,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.jumpToIndex(state,0)).toBe(state);expect(NavigationStateUtils.jumpToIndex(state,1)).toEqual(newState);});it('throws if jumps to invalid index',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(function(){return NavigationStateUtils.jumpToIndex(state,2);}).toThrow('invalid index 2 to jump to');});it('jumps to new key',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:1,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.jumpTo(state,'a')).toBe(state);expect(NavigationStateUtils.jumpTo(state,'b')).toEqual(newState);});it('throws if jumps to invalid key',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(function(){return NavigationStateUtils.jumpTo(state,'c');}).toThrow('invalid index -1 to jump to');});it('move backwards',function(){var state={index:1,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.back(state)).toEqual(newState);expect(NavigationStateUtils.back(newState)).toBe(newState);});it('move forwards',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:1,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.forward(state)).toEqual(newState);expect(NavigationStateUtils.forward(newState)).toBe(newState);});it('Replaces by key',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:1,routes:[{key:'a',routeName:routeName},{key:'c',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.replaceAt(state,'b',{key:'c',routeName:routeName})).toEqual(newState);});it('Replaces by index',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:1,routes:[{key:'a',routeName:routeName},{key:'c',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.replaceAtIndex(state,1,{key:'c',routeName:routeName})).toEqual(newState);});it('Returns the state with updated index if route is unchanged but index changes',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.replaceAtIndex(state,1,state.routes[1])).toEqual(_objectSpread({},state,{index:1}));});it('Resets routes',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:1,routes:[{key:'x',routeName:routeName},{key:'y',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.reset(state,[{key:'x',routeName:routeName},{key:'y',routeName:routeName}])).toEqual(newState);expect(function(){NavigationStateUtils.reset(state,[]);}).toThrow('invalid routes to replace');});it('Resets routes with index',function(){var state={index:0,routes:[{key:'a',routeName:routeName},{key:'b',routeName:routeName}],isTransitioning:false};var newState={index:0,routes:[{key:'x',routeName:routeName},{key:'y',routeName:routeName}],isTransitioning:false};expect(NavigationStateUtils.reset(state,[{key:'x',routeName:routeName},{key:'y',routeName:routeName}],0)).toEqual(newState);expect(function(){NavigationStateUtils.reset(state,[{key:'x',routeName:routeName},{key:'y',routeName:routeName}],100);}).toThrow('invalid index 100 to reset');});});
//# sourceMappingURL=NavigationStateUtils-test.js.map