'use strict';

var isWhat = require('is-what');

function mergeRecursively(origin, newComer, extensions) {
    // work directly on newComer if its not an object
    if (!isWhat.isPlainObject(newComer)) {
        // extend merge rules
        if (extensions && isWhat.isArray(extensions)) {
            extensions.forEach(function (extend) {
                newComer = extend(origin, newComer);
            });
        }
        return newComer;
    }
    // define newObject to merge all values upon
    var newObject = (isWhat.isPlainObject(origin))
        ? Object.keys(origin)
            .reduce(function (carry, key) {
            var targetVal = origin[key];
            // @ts-ignore
            if (!Object.keys(newComer).includes(key))
                carry[key] = targetVal;
            return carry;
        }, {})
        : {};
    return Object.keys(newComer)
        .reduce(function (carry, key) {
        // re-define the origin and newComer as targetVal and newVal
        var newVal = newComer[key];
        var targetVal = (isWhat.isPlainObject(origin))
            ? origin[key]
            : undefined;
        // extend merge rules
        if (extensions && isWhat.isArray(extensions)) {
            extensions.forEach(function (extend) {
                newVal = extend(targetVal, newVal);
            });
        }
        // early return when targetVal === undefined
        if (targetVal === undefined) {
            carry[key] = newVal;
            return carry;
        }
        // When newVal is an object do the merge recursively
        if (isWhat.isPlainObject(newVal)) {
            carry[key] = mergeRecursively(targetVal, newVal, extensions);
            return carry;
        }
        // all the rest
        carry[key] = newVal;
        return carry;
    }, newObject);
}
/**
 * Merge anything recursively.
 * Objects get merged, special objects (classes etc.) are re-assigned "as is".
 * Basic types overwrite objects or other basic types.
 *
 * @param {(IConfig | any)} origin
 * @param {...any[]} newComers
 * @returns the result
 */
function index (origin) {
    var newComers = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        newComers[_i - 1] = arguments[_i];
    }
    var extensions = null;
    var base = origin;
    if (isWhat.isPlainObject(origin) && origin.extensions && Object.keys(origin).length === 1) {
        base = {};
        extensions = origin.extensions;
    }
    return newComers.reduce(function (result, newComer) {
        return mergeRecursively(result, newComer, extensions);
    }, base);
}

module.exports = index;
