/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict";

const meta = require("../../shared/output/meta");

const _require = require("./util"),
  getModuleCodeAndMap = _require.getModuleCodeAndMap,
  concat = _require.concat;

const _require2 = require("metro-source-map"),
  createIndexMap = _require2.createIndexMap;

function asPlainBundle(_ref) {
  let filename = _ref.filename,
    idsForPath = _ref.idsForPath,
    modules = _ref.modules,
    requireCalls = _ref.requireCalls,
    sourceMapPath = _ref.sourceMapPath,
    enableIDInlining = _ref.enableIDInlining;
  let code = "";
  let line = 0;
  const sections = [];

  const modIdForPath = x => idsForPath(x).moduleId;

  for (const module of concat(modules, requireCalls)) {
    const _getModuleCodeAndMap = getModuleCodeAndMap(module, modIdForPath, {
        enableIDInlining
      }),
      moduleCode = _getModuleCodeAndMap.moduleCode,
      moduleMap = _getModuleCodeAndMap.moduleMap;

    code += moduleCode + "\n";

    if (moduleMap) {
      sections.push({
        map: moduleMap,
        offset: {
          column: 0,
          line
        }
      });
    }

    line += countLines(moduleCode);
  }

  if (sourceMapPath) {
    code += `//# sourceMappingURL=${sourceMapPath}`;
  }

  return {
    code,
    extraFiles: [[`${filename}.meta`, meta(code)]],
    map: createIndexMap(filename, sections)
  };
}

module.exports = asPlainBundle;
const reLine = /^/gm;

function countLines(string) {
  //$FlowFixMe This regular expression always matches
  return string.match(reLine).length;
}
