import _assertThisInitialized from "@babel/runtime/helpers/esm/assertThisInitialized";
import _inheritsLoose from "@babel/runtime/helpers/esm/inheritsLoose";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { ReactReduxContext } from './Context';
import Subscription from '../utils/Subscription';

var Provider =
/*#__PURE__*/
function (_Component) {
  _inheritsLoose(Provider, _Component);

  function Provider(props) {
    var _this;

    _this = _Component.call(this, props) || this;
    var store = props.store;
    _this.notifySubscribers = _this.notifySubscribers.bind(_assertThisInitialized(_this));
    var subscription = new Subscription(store);
    subscription.onStateChange = _this.notifySubscribers;
    _this.state = {
      store: store,
      subscription: subscription
    };
    _this.previousState = store.getState();
    return _this;
  }

  var _proto = Provider.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this._isMounted = true;
    this.state.subscription.trySubscribe();

    if (this.previousState !== this.props.store.getState()) {
      this.state.subscription.notifyNestedSubs();
    }
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    if (this.unsubscribe) this.unsubscribe();
    this.state.subscription.tryUnsubscribe();
    this._isMounted = false;
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (this.props.store !== prevProps.store) {
      this.state.subscription.tryUnsubscribe();
      var subscription = new Subscription(this.props.store);
      subscription.onStateChange = this.notifySubscribers;
      this.setState({
        store: this.props.store,
        subscription: subscription
      });
    }
  };

  _proto.notifySubscribers = function notifySubscribers() {
    this.state.subscription.notifyNestedSubs();
  };

  _proto.render = function render() {
    var Context = this.props.context || ReactReduxContext;
    return React.createElement(Context.Provider, {
      value: this.state
    }, this.props.children);
  };

  return Provider;
}(Component);

Provider.propTypes = {
  store: PropTypes.shape({
    subscribe: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired,
    getState: PropTypes.func.isRequired
  }),
  context: PropTypes.object,
  children: PropTypes.any
};
export default Provider;