/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


goog.provide('shaka.ui.Constants');


/**
 * @const {string}
 */
shaka.ui.Constants.ARIA_LABEL = 'aria-label';


/**
 * @const {string}
 */
shaka.ui.Constants.SEEK_BAR_BASE_COLOR = 'rgba(255, 255, 255, 0.3)';


/**
 * @const {string}
 */
shaka.ui.Constants.SEEK_BAR_PLAYED_COLOR = 'rgb(255, 255, 255)';


/**
 * @const {string}
 */
shaka.ui.Constants.SEEK_BAR_BUFFERED_COLOR = 'rgba(255, 255, 255, 0.54)';


/**
 * @const {string}
 */
shaka.ui.Constants.VOLUME_BAR_VOLUME_LEVEL_COLOR = 'rgb(255, 255, 255)';


/**
 * @const {string}
 */
shaka.ui.Constants.VOLUME_BAR_BASE_COLOR = 'rgba(255, 255, 255, 0.54)';


/**
 * @const {number}
 */
shaka.ui.Constants.MIN_SEEK_WINDOW_TO_SHOW_SEEKBAR = 5; // seconds


/**
 * @const {number}
 */
shaka.ui.Constants.KEYCODE_TAB = 9;


/**
 * @const {number}
 */
shaka.ui.Constants.KEYCODE_SHIFT = 16;


/**
 * @const {number}
 */
shaka.ui.Constants.KEYCODE_ESCAPE = 27;
