/*
 * Copyright (c) 2011 Roberto Tyley
 *
 * This file is part of 'Agit' - an Android Git client.
 *
 * Agit is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Agit is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.madgag.agit.views;

import android.view.View;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;

public abstract class OSV<T extends RevObject> {

	public abstract void setObject(T obj, View view, Repository repo);

    public abstract int iconId();

    public abstract int layoutId();

    public abstract CharSequence getTypeName();
}
