/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.googlecode.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.bluecow.googlecode.ant.Base64;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GoogleCodeUploadTask
extends Task {
    private String userName;
    private String password;
    private String projectName;
    private String fileName;
    private String targetFileName;
    private String summary;
    private String uploadUrl;
    private boolean verbose;
    private String labels;

    public void execute() throws BuildException {
        try {
            this.upload();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void upload() throws IOException {
        int count;
        String[] labelArray;
        System.clearProperty("javax.net.ssl.trustStoreProvider");
        System.clearProperty("javax.net.ssl.trustStoreType");
        String BOUNDARY = "CowMooCowMooCowCowCow";
        URL url = this.createUploadURL();
        this.log("The upload URL is " + url);
        InputStream in = new BufferedInputStream(new FileInputStream(this.fileName));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestProperty("Authorization", "Basic " + GoogleCodeUploadTask.createAuthToken(this.userName, this.password));
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=CowMooCowMooCowCowCow");
        conn.setRequestProperty("User-Agent", "Google Code Upload Ant Task 0.1");
        this.log("Attempting to connect (username is " + this.userName + ")...");
        conn.connect();
        this.log("Sending request parameters...");
        OutputStream out = conn.getOutputStream();
        this.sendLine(out, "--CowMooCowMooCowCowCow");
        this.sendLine(out, "content-disposition: form-data; name=\"summary\"");
        this.sendLine(out, "");
        this.sendLine(out, this.summary);
        if (this.labels != null && (labelArray = this.labels.split("\\,")) != null && labelArray.length > 0) {
            this.log("Setting " + labelArray.length + " label(s)");
            int n = 0;
            int i = labelArray.length;
            while (n < i) {
                this.sendLine(out, "--CowMooCowMooCowCowCow");
                this.sendLine(out, "content-disposition: form-data; name=\"label\"");
                this.sendLine(out, "");
                this.sendLine(out, labelArray[n].trim());
                ++n;
            }
        }
        String upFileName = null;
        upFileName = this.targetFileName != null && !this.targetFileName.isEmpty() ? this.targetFileName : new File(this.fileName).getName();
        this.log("Sending file... " + upFileName);
        this.sendLine(out, "--CowMooCowMooCowCowCow");
        this.sendLine(out, "content-disposition: form-data; name=\"filename\"; filename=\"" + upFileName + "\"");
        this.sendLine(out, "Content-Type: application/octet-stream");
        this.sendLine(out, "");
        byte[] buf = new byte[8192];
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        in.close();
        this.sendLine(out, "");
        this.sendLine(out, "--CowMooCowMooCowCowCow--");
        out.flush();
        out.close();
        in = conn.getInputStream();
        this.log("Upload finished. Reading response.");
        this.log("HTTP Response Headers: " + conn.getHeaderFields());
        StringBuilder responseBody = new StringBuilder();
        while ((count = in.read(buf)) >= 0) {
            responseBody.append(new String(buf, 0, count, "ascii"));
        }
        this.log(responseBody.toString());
        in.close();
        conn.disconnect();
    }

    private void sendLine(OutputStream out, String string) throws IOException {
        out.write(string.getBytes("ascii"));
        out.write("\r\n".getBytes("ascii"));
    }

    private static String createAuthToken(String userName, String password) {
        String string = String.valueOf(userName) + ":" + password;
        try {
            return Base64.encodeBytes(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException notreached) {
            throw new InternalError(notreached.toString());
        }
    }

    private URL createUploadURL() throws MalformedURLException {
        if (this.uploadUrl != null) {
            return new URL(this.uploadUrl);
        }
        if (this.projectName == null) {
            throw new NullPointerException("projectName must be set");
        }
        return new URL("https", String.valueOf(this.projectName) + ".googlecode.com", "/files");
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }
}

