/*
* Copyright (C) 2017 Yonnji Nyyoka, yonnji@miqote.com
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 3
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
package com.miqote.shanawp;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Rect;

public class Spark {

    private Bitmap[] frames;
    private Rect bounds;
    private int width;
    private int height;
    private int id;
    private float radius;
    private float direction;
    private float x;
    private float y;

    public Spark(Bitmap[] f, int w, int h) {
        frames = f;
        bounds = new Rect(0, 0, w, h);
        width = w;
        height = h;
        id = (int) Math.floor(frames.length * Math.random());
        radius = (width + height) / 4f;
        reset();
    }

    public float getX() {
        return x;
    }

    public float getY() {
        return y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void reset() {
        direction = (float) (30 + (180 - 30 * 2) * Math.random());
    }

    public void draw(Canvas canvas) {
        canvas.translate(x, y);
        canvas.drawBitmap(frames[id], null, bounds, null);
        canvas.translate(-x, -y);
        if (id >= frames.length - 1) {
            id = 0;
        } else {
            id++;
        }
        x -= Math.cos(direction) * radius;
        y += Math.abs(Math.sin(direction) * radius);
    }
}
