"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const listr_1 = require("./listr");
class Manager {
    constructor(options) {
        this.tasks = [];
        this.options = Object.assign({ showSubtasks: true, collapse: false }, options);
    }
    set ctx(ctx) {
        this.options.ctx = ctx;
    }
    add(tasks, options) {
        options = { ...this.options, ...options };
        this.tasks = [...this.tasks, this.indent(tasks, options)];
    }
    async runAll(options) {
        options = { ...this.options, ...options };
        const ctx = await this.run(this.tasks, options);
        this.tasks = [];
        return ctx;
    }
    newListr(tasks, options) {
        return new listr_1.Listr(tasks, options);
    }
    indent(tasks, options, taskOptions) {
        options = { ...this.options, ...options };
        let newTask;
        if (typeof tasks === 'function') {
            newTask = {
                ...taskOptions,
                task: (ctx) => this.newListr(tasks(ctx), options)
            };
        }
        else {
            newTask = {
                ...taskOptions,
                task: () => this.newListr(tasks, options)
            };
        }
        return newTask;
    }
    run(tasks, options) {
        options = { ...this.options, ...options };
        return this.newListr(tasks, options).run();
    }
    getRuntime(pipetime) {
        return `${Math.round(Date.now() - pipetime) / 1000}s`;
    }
}
exports.Manager = Manager;
//# sourceMappingURL=manager.js.map