"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../utils/logger");
class TestRenderer {
    constructor(tasks, options) {
        this.tasks = tasks;
        this.options = options;
        this.logger = new logger_1.Logger({ direct: true });
    }
    render() {
        this.testRenderer(this.tasks);
    }
    end() { }
    testRenderer(tasks) {
        return tasks === null || tasks === void 0 ? void 0 : tasks.forEach((task) => {
            task.subscribe((event) => {
                if (task.isEnabled()) {
                    if (event.type === 'SUBTASK' && task.hasSubtasks()) {
                        this.testRenderer(task.subtasks);
                    }
                    else if (event.type === 'STATE') {
                        const taskTitle = task.hasTitle() ? task.title : 'Task without title.';
                        if (task.isPending()) {
                            this.logger.start(taskTitle);
                        }
                        else if (task.isCompleted()) {
                            this.logger.success(taskTitle);
                        }
                    }
                    else if (event.type === 'DATA') {
                        if (task.isSkipped()) {
                            this.logger.skip(String(event.data));
                        }
                        else if (task.hasFailed()) {
                            this.logger.fail(String(event.data));
                        }
                        else {
                            this.logger.data(String(event.data));
                        }
                    }
                    else if (event.type === 'TITLE') {
                        this.logger.title(String(event.data));
                    }
                }
            }, (err) => {
                this.logger.fail(err);
            });
        });
    }
}
exports.TestRenderer = TestRenderer;
TestRenderer.nonTTY = true;
//# sourceMappingURL=test.renderer.js.map