"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const prompts_1 = require("enquirer/lib/prompts");
const listr_interface_1 = require("../interfaces/listr.interface");
const task_wrapper_1 = require("../lib/task-wrapper");
function newPrompt(type, options) {
    let prompt;
    switch (type.toString().toLocaleLowerCase()) {
        case 'autocomplete':
            prompt = new prompts_1.AutoComplete(options);
            break;
        case 'basicauth':
            prompt = new prompts_1.BasicAuth(options);
            break;
        case 'confirm':
            prompt = new prompts_1.Confirm(options);
            break;
        case 'editable':
            prompt = new prompts_1.Editable(options);
            break;
        case 'form':
            prompt = new prompts_1.Form(options);
            break;
        case 'input':
            prompt = new prompts_1.Input(options);
            break;
        case 'invisible':
            prompt = new prompts_1.Invisible(options);
            break;
        case 'list':
            prompt = new prompts_1.List(options);
            break;
        case 'multiselect':
            prompt = new prompts_1.MultiSelect(options);
            break;
        case 'numeral':
            prompt = new prompts_1.Numeral(options);
            break;
        case 'password':
            prompt = new prompts_1.Password(options);
            break;
        case 'quiz':
            prompt = new prompts_1.Quiz(options);
            break;
        case 'scale':
            prompt = new prompts_1.Scale(options);
            break;
        case 'select':
            prompt = new prompts_1.Select(options);
            break;
        case 'snippet':
            prompt = new prompts_1.Snippet(options);
            break;
        case 'sort':
            prompt = new prompts_1.Sort(options);
            break;
        case 'survey':
            prompt = new prompts_1.Survey(options);
            break;
        case 'text':
            prompt = new prompts_1.Text(options);
            break;
        case 'toggle':
            prompt = new prompts_1.Toggle(options);
            break;
        default:
            throw new listr_interface_1.ListrError('No prompt type this was not supposed to happen.');
    }
    return prompt;
}
exports.newPrompt = newPrompt;
function isPromptClass(SomeClass) {
    try {
        new SomeClass({});
        return true;
    }
    catch {
        return false;
    }
}
function createPrompt(type, options, settings) {
    let cancelCallback;
    if (settings === null || settings === void 0 ? void 0 : settings.cancelCallback) {
        cancelCallback = settings.cancelCallback;
    }
    else {
        cancelCallback = defaultCancelCallback;
    }
    if (isPromptClass(type)) {
        return new type(options).on('cancel', cancelCallback.bind(this)).run();
    }
    else {
        return newPrompt(type, options).on('cancel', cancelCallback.bind(this)).run();
    }
}
exports.createPrompt = createPrompt;
function defaultCancelCallback(settings) {
    const errorMsg = 'Cancelled prompt.';
    if ((settings === null || settings === void 0 ? void 0 : settings.error) === true) {
        throw new listr_interface_1.PromptError(errorMsg);
    }
    else if (this instanceof task_wrapper_1.TaskWrapper) {
        this.task.prompt = new listr_interface_1.PromptError(errorMsg);
    }
    else {
        return errorMsg;
    }
}
//# sourceMappingURL=prompt.js.map