# arr-union [![NPM version](https://badge.fury.io/js/arr-union.svg)](http://badge.fury.io/js/arr-union)  [![Build Status](https://travis-ci.org/jonschlinkert/arr-union.svg)](https://travis-ci.org/jonschlinkert/arr-union)

> Combines a list of arrays, returning a single array with unique values, using strict equality for comparisons.

This library is **15-20 times faster** and more performant (scales better) than [array-union](https://github.com/sindresorhus/array-union), which just uses `[].concat.apply([], arguments)`.

## Benchmarks

See the [benchmarks](./benchmark).

```bash
#1: five-arrays.js
  array-union.js x 245,487 ops/sec ±0.99% (96 runs sampled)
  current.js x 5,267,661 ops/sec ±0.63% (98 runs sampled)

#2: ten-arrays.js
  array-union.js x 134,784 ops/sec ±0.51% (94 runs sampled)
  current.js x 1,919,143 ops/sec ±0.45% (100 runs sampled)

#3: two-arrays.js
  array-union.js x 308,374 ops/sec ±0.75% (96 runs sampled)
  current.js x 7,361,915 ops/sec ±0.67% (95 runs sampled)
```

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i arr-union --save
```

## Usage

```js
var union = require('arr-union');

union(['a'], ['b', 'c'], ['d', 'e', 'f']);
//=> ['a', 'b', 'c', 'd', 'e', 'f']
```

Returns only unique elements:

```js
union(['a', 'a'], ['b', 'c']);
//=> ['a', 'b', 'c']
```

## Other array utilities

* [arr-diff](https://github.com/jonschlinkert/arr-diff): Returns an array with only the unique values from the first array, by excluding all… [more](https://github.com/jonschlinkert/arr-diff)
* [arr-flatten](https://github.com/jonschlinkert/arr-flatten): Recursively flatten an array or arrays. This is the fastest implementation of array flatten.
* [arr-filter](https://github.com/jonschlinkert/arr-filter): Faster alternative to javascript's native filter method.
* [arr-map](https://github.com/jonschlinkert/arr-map): Faster, node.js focused alternative to JavaScript's native array map.
* [arr-pluck](https://github.com/jonschlinkert/arr-pluck): Retrieves the value of a specified property from all elements in the collection.
* [arr-reduce](https://github.com/jonschlinkert/arr-reduce): Fast array reduce that also loops over sparse elements.
* [array-unique](https://github.com/jonschlinkert/array-unique): Return an array free of duplicate values. Fastest ES5 implementation.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/arr-union/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on June 15, 2015._
