/**
* Copyright (c) Facebook, Inc. and its affiliates.
*
* This source code is licensed under the MIT license found in the
* LICENSE file in the root directory of this source tree.
*
* @generated by codegen project: GeneratePropsJavaDelegate.js
*/

package com.facebook.react.viewmanagers;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.BaseViewManagerDelegate;
import com.facebook.react.uimanager.BaseViewManagerInterface;
import com.facebook.react.uimanager.LayoutShadowNode;

public class ProgressViewManagerDelegate<T extends View, U extends BaseViewManagerInterface<T> & ProgressViewManagerInterface<T>> extends BaseViewManagerDelegate<T, U> {
  public ProgressViewManagerDelegate(U viewManager) {
    super(viewManager);
  }
  @Override
  public void setProperty(T view, String propName, @Nullable Object value) {
    switch (propName) {
      case "progressViewStyle":
        mViewManager.setProgressViewStyle(view, (String) value);
        break;
      case "progress":
        mViewManager.setProgress(view, value == null ? 0f : ((Double) value).floatValue());
        break;
      case "progressTintColor":
        mViewManager.setProgressTintColor(view, value == null ? null : ((Double) value).intValue());
        break;
      case "trackTintColor":
        mViewManager.setTrackTintColor(view, value == null ? null : ((Double) value).intValue());
        break;
      case "progressImage":
        mViewManager.setProgressImage(view, (ReadableMap) value);
        break;
      case "trackImage":
        mViewManager.setTrackImage(view, (ReadableMap) value);
        break;
      default:
        super.setProperty(view, propName, value);
    }
  }
}
