/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.data;

import java.util.ArrayList;

import android.app.Activity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.TextView;

import com.mykola.lexinproject.R;

public class AttachmentsAdapter extends ArrayAdapter<Translation.Attachment> {
	private final static String TAG = "AttachmentsAdapter";
	private final Activity mActivity;
	private final ArrayList<Translation.Attachment> mAttachments;
	private final IListener mListener;

	public interface IListener {
		public void onPlay(Translation.Attachment attachment);
	}

	public AttachmentsAdapter(Activity activity,
			ArrayList<Translation.Attachment> attachemnts, IListener listener) {
		super(activity, android.R.layout.simple_list_item_1, attachemnts);
		this.mActivity = activity;
		this.mAttachments = attachemnts;
		this.mListener = listener;
	}

	public static class ViewHolder {
		public TextView mItemTitle;
		public TextView mItemSubTitle;
		public Button mPlayButton;
	}

	public int getCount() {
		return mAttachments.size();
	}

	public Translation.Attachment getItem(int position) {
		if(getCount() > position) {
			return mAttachments.get(position);
		} else {
			return null;
		}
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View view = convertView;
		ViewHolder holder;
		if (view == null) {
			holder = new ViewHolder();
			view = mActivity.getLayoutInflater().inflate(
					R.layout.list_item_attachments, null);
			holder.mItemTitle = (TextView) view
					.findViewById(R.id.attachment_title);
			holder.mItemSubTitle = (TextView) view
					.findViewById(R.id.attachment_subtitle);
			holder.mPlayButton = (Button) view
					.findViewById(R.id.history_button_play);
			view.setTag(holder);
		} else {
			holder = (ViewHolder) view.getTag();
		}
		final Translation.Attachment attachment = mAttachments.get(position);
		if (attachment != null) {
			holder.mItemTitle.setText(attachment.mTitle);
			holder.mItemSubTitle.setText(attachment.mUrl);
			holder.mPlayButton.setOnClickListener(new OnClickListener() {
				public void onClick(View v) {
					mListener.onPlay(attachment);
				}
			});
		}
		return view;
	}

	@Override
	public long getItemId(int position) {
		return 0;
	}
}