/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.data;

import java.util.ArrayList;
import java.util.List;

import android.os.Parcel;
import android.os.Parcelable;

public class Language implements Parcelable {
	private String[] mNames;
	private final int mPos;
	private final int mId;

	public Language(int pos, int id, String... names) {
		this.mPos = pos;
		this.mNames = names;
		this.mId = id;
	}

	public String getName() {
		return mNames[mPos];
	}

	public String getShortcut() {
		return mNames[0];
	}

	public int getId() {
		return mId;
	}

	public Language(Parcel in) {
		mNames = new String[1];
		List<String> list = new ArrayList<String>();
		in.readStringList(list);
		mNames = list.toArray(new String[list.size()]);
		mPos = in.readInt();
		mId = in.readInt();
	}

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < mNames.length; i++) {
			list.add(mNames[i]);
		}
		dest.writeStringList(list);
		dest.writeInt(mPos);
		dest.writeInt(mId);
	}

	public static final Parcelable.Creator<Language> CREATOR = new Creator<Language>() {
		public Language createFromParcel(Parcel source) {
			return new Language(source);
		}

		public Language[] newArray(int size) {
			return new Language[size];
		}
	};
}
