/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.data;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.SpinnerAdapter;
import android.widget.TextView;

import com.mykola.lexinproject.R;

public class LanguagesAdapter extends BaseAdapter implements SpinnerAdapter {
	private final Activity mActivity;
	private final Language[] mLanguages;

	public LanguagesAdapter(Activity activity, Language[] languages) {
		this.mActivity = activity;
		this.mLanguages = languages;
	}

	public static class ViewHolder {
		public TextView mItem;
	}

	public int getCount() {
		return mLanguages.length;
	}

	public Object getItem(int position) {
		if(getCount() > position) {
			return mLanguages[position];
		} else {
			return null;
		}
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View view = convertView;
		ViewHolder holder;
		if (view == null) {
			holder = new ViewHolder();
			view = mActivity.getLayoutInflater().inflate(R.layout.spin_layout,
					null);
			holder.mItem = (TextView) view.findViewById(R.id.field2);
			view.setTag(holder);
		} else {
			holder = (ViewHolder) view.getTag();
		}
		final Language language = mLanguages[position];
		if (language != null) {
			holder.mItem.setText(language.getName());
		}
		return view;
	}

	@Override
	public long getItemId(int position) {
		// TODO Auto-generated method stub
		return 0;
	}
}