/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.providers;

import java.util.ArrayList;

import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;

import com.actionbarsherlock.app.SherlockFragment;
import com.mykola.lexinproject.data.Translation;
import com.mykola.lexinproject.ui.IUIListener;

abstract public class TranslatorBase {
	private final static String XML_PRUNED_TAGS = "img,button,script,iframe,textarea,input";
	private final static String TAG = "TranslatorBase";
	private final IUIListener mListener;
	private final HtmlCleaner mCleaner;
	private STATE mState;

	protected enum STATE {
		eTranslate, eStop,
	}

	public interface IListener {
		public void responseWebGet(Translation translation);
		public void responseWebGetVariants(ArrayList<String> words);
		public void responseWebGetNotFound(String message);
	}
	
	public TranslatorBase(SherlockFragment parent) {
		this.setState(STATE.eStop);
		this.mCleaner = new HtmlCleaner();
		try {
			this.mListener = (IUIListener) parent;
		} catch (ClassCastException e) {
			throw new ClassCastException(parent.toString()
					+ " must implement IUIListener");
		}
		CleanerProperties props = mCleaner.getProperties();
		props.setAllowHtmlInsideAttributes(true);
		props.setAllowMultiWordAttributes(true);
		props.setRecognizeUnicodeChars(true);
		props.setOmitComments(true);
		props.setPruneTags(XML_PRUNED_TAGS);
	}

	public HtmlCleaner getCleaner() {
		return mCleaner;
	}

	public void setState(STATE mState) {
		this.mState = mState;
	}

	public STATE getState() {
		return mState;
	}

	protected IUIListener getListener() {
		return mListener;
	}
	
	abstract public void translate(final Translation translation,
			IListener listener);

	abstract public void stop ();	
}
