/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.ui;

import java.util.ArrayList;

import android.app.Activity;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnCompletionListener;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;

import com.actionbarsherlock.app.SherlockFragment;
import com.mykola.lexinproject.R;
import com.mykola.lexinproject.data.AttachmentsAdapter;
import com.mykola.lexinproject.data.Translation;
import com.mykola.lexinproject.data.Translation.Attachment;
import com.mykola.lexinproject.utils.LogUtils;

public class AttachmentsFragment extends SherlockFragment implements
		OnCompletionListener, AttachmentsAdapter.IListener, IUIListener {
	private final static String TAG = "AttachmentsFragment";
	private final static String STATE_ATTACHMENTS_VALUE = "attachments_value";
	private ListView mListView;
	private Translation mSharedData;
	private MediaPlayer mMediaPlayer;
	private AsyncTask<?, ?, ?> mMediaPlayerTask;

	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		LogUtils.LOGD(TAG, "onCreateView >>");
		View view = inflater.inflate(R.layout.attachments_fragment, container,
				false);
		getSherlockActivity().getSupportActionBar().setHomeButtonEnabled(true);
		getSherlockActivity().getSupportActionBar().setDisplayHomeAsUpEnabled(
				true);
		mListView = (ListView) view.findViewById(R.id.listView1);
		if (savedInstanceState != null) {
			LogUtils.LOGD(TAG, "savedInstanceState available");
			if (savedInstanceState.containsKey(STATE_ATTACHMENTS_VALUE)) {
				mSharedData = savedInstanceState
						.getParcelable(STATE_ATTACHMENTS_VALUE);
			}
		}
		if (mSharedData == null
				&& getArguments().containsKey(PreviewFragment.SHARED_DATA)) {
			LogUtils.LOGD(TAG, "getArguments available");
			mSharedData = getArguments().getParcelable(
					PreviewFragment.SHARED_DATA);
		}
		mMediaPlayer = new MediaPlayer();
		mMediaPlayer.setOnCompletionListener(this);
		if (mSharedData != null) {
			AttachmentsAdapter adapter = new AttachmentsAdapter(getActivity(),
					mSharedData.getAttachmentsArray(), this);
			mListView.setAdapter(adapter);
		}
		getSherlockActivity()
			.setSupportProgressBarIndeterminateVisibility(
			Boolean.FALSE);
		LogUtils.LOGD(TAG, "onCreateView <<");
		return view;
	}

	@Override
	public void onAttach(Activity activity) {
		LogUtils.LOGD(TAG, "onAttach");
		super.onAttach(activity);
	}
	
	@Override
	public void onDetach() {
		LogUtils.LOGD(TAG, "onDetach");
		super.onDetach();
	}
	
	@Override
	public void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		LogUtils.LOGD(TAG, "onSaveInstanceState >>");
		if (mSharedData != null) {
			outState.putParcelable(STATE_ATTACHMENTS_VALUE, mSharedData);
		}
		LogUtils.LOGD(TAG, "onSaveInstanceState <<");
	}

	@Override
	public void onPause() {
		LogUtils.LOGD(TAG, "onPause >>");
		stopProgress();
		if (mMediaPlayerTask != null) {
			mMediaPlayerTask.cancel(true);
			mMediaPlayerTask = null;
		}
		LogUtils.LOGD(TAG, "onPause <<");
		super.onPause();
	}

	@Override
	public void onResume() {
		super.onResume();
		LogUtils.LOGD(TAG, "onResume >>");
		LogUtils.LOGD(TAG, "onResume <<");
	}

	@Override
	public void onCompletion(MediaPlayer mp) {
		LogUtils.LOGD(TAG, "onCompletion");
		stopProgress();
		mMediaPlayer.reset();
	}

	@Override
	public void onPlay(final Attachment attachment) {
		LogUtils.LOGD(TAG, "onPlay >>");
		if ((!TextUtils.isEmpty(attachment.mUrl)) && (mMediaPlayerTask == null)
				&& !mMediaPlayer.isPlaying()) {
			startProgress();
			mMediaPlayerTask = new AsyncTask<Void, Void, Void>() {
				@Override
				protected Void doInBackground(Void... arg0) {
					try {
						mMediaPlayer.reset();
						mMediaPlayer.setDataSource(attachment.mUrl);
						mMediaPlayer.prepare();
						mMediaPlayer.start();
					} catch (Exception exceptipn) {
						LogUtils.LOGD(TAG, "onItemClick", exceptipn);
					}
					return null;
				}

				@Override
				protected void onCancelled(Void result) {
					LogUtils.LOGD(TAG, "onCancelled");
					super.onCancelled(result);
					mMediaPlayer.reset();
				}

				@Override
				protected void onPostExecute(Void result) {
					super.onPostExecute(result);
					mMediaPlayerTask = null;
				}

			}.execute();
		}
		LogUtils.LOGD(TAG, "onPlay <<");
	}

	@Override
	public void startProgress() {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(TAG, "startProgress >>");
					getSherlockActivity()
							.setSupportProgressBarIndeterminateVisibility(
									Boolean.TRUE);
					LogUtils.LOGD(TAG, "startProgress <<");
				}
			});
		}
	}

	@Override
	public void stopProgress() {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(TAG, "stopProgress >>");
					getSherlockActivity()
							.setSupportProgressBarIndeterminateVisibility(
									Boolean.FALSE);
					LogUtils.LOGD(TAG, "stopProgress <<");
				}
			});
		}
	}

	@Override
	public void showOnView(String content) {
		LogUtils.LOGE(TAG, "showOnWebView");
	}

	@Override
	public void onFoundVariants(ArrayList<String> words) {
		LogUtils.LOGE(TAG, "onFoundVariants");
	}

	@Override
	public void onFound(Translation translation) {
		LogUtils.LOGE(TAG, "onFound");
	}

	@Override
	public void onFound(ArrayList<Translation> translations) {
		LogUtils.LOGE(TAG, "onFound");
	}

	@Override
	public void onFoundWords(ArrayList<String> words) {
		LogUtils.LOGE(TAG, "onFoundWords");
	}

	@Override
	public void onNotFound(String message) {
		LogUtils.LOGE(TAG, "onNotFound");
	}
}
