/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.ui;

import java.util.ArrayList;

import com.mykola.lexinproject.data.Translation;

public interface IUIListener {

	public void startProgress();

	public void stopProgress();

	public void showOnView(final String content);

	public void onFoundVariants(ArrayList<String> words);

	public void onFound(Translation translation);
	
	public void onNotFound(String message);
	
	public void onFound(ArrayList<Translation> translations);

	public void onFoundWords(ArrayList<String> words);
}
