/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.ui;

import java.util.ArrayList;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.Html;
import android.text.method.ScrollingMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

import com.actionbarsherlock.app.SherlockFragment;
import com.mykola.lexinproject.R;
import com.mykola.lexinproject.data.Language;
import com.mykola.lexinproject.data.LanguagesAdapter;
import com.mykola.lexinproject.data.Translation;
import com.mykola.lexinproject.providers.TranslationManager;
import com.mykola.lexinproject.utils.LogUtils;
import com.mykola.lexinproject.utils.UIUtils;

public class PreviewFragment extends SherlockFragment implements IUIListener {
	public static final String ID_REQUEST = "ID_REQUEST";
	public static final String ID_TYPE = "ID_TYPE";
	public static final String ID_LANGUAGE = "ID_LANGUAGE";
	public static final String ID_SEARCH = "ID_SEARCH";
	private static final String STATE_TYPE_POS = "type_pos";
	private static final String STATE_LANGUAGE_POS = "language_pos";
	private static final String STATE_TRANSLATE_VALUE = "translate_value";
	private static final String EMPTY_BODY = "";
	private static final String TAG = "PreviewFragment";
	public static final String ARG_SECTION_NUMBER = "section_number";
	public static final String SHARED_DATA = "shared_data";

	private TranslationManager mTranslationFactory;
	private Spinner mSpinnerLanguages;
	private Spinner mSpinnerType;
	private TextView mTranslationView;
	private AutoCompleteTextView mTextView;
	private Button mOkButton;
	private Button mCancelButton;
	private Translation mSharedData;
	private ArrayList<String> mSharedWords;
	private IUIListener mListener = LexinActivity.sDummyListener;

	// private Dialog mProgressDialog;

	private final class TypeSelectedListener implements OnItemSelectedListener {
		public void onItemSelected(AdapterView<?> parent, View view,
				int position, long id) {
			if (parent.getCount() > position) {
				final String selectedItem = (String) parent
						.getItemAtPosition(position);
				LogUtils.LOGD(TAG, "onItemSelected " + selectedItem);
				final Bundle extras = getActivity().getIntent().getExtras();
				if (extras != null) {
					LogUtils.LOGD(TAG,
							"Intent ID_SEARCH " + extras.getBoolean(ID_SEARCH));
					if (extras.getBoolean(ID_SEARCH)) {
						doTranslate();
					}
					getActivity().setIntent(
							new Intent(getActivity(), LexinActivity.class));
				}
			}
		}

		@Override
		public void onNothingSelected(AdapterView<?> arg0) {
			// TODO Auto-generated method stub
		}
	}

	private final class LanguageSelectedListener implements
			OnItemSelectedListener {
		private final Bundle savedInstanceState;

		private LanguageSelectedListener(Bundle savedInstanceState) {
			this.savedInstanceState = savedInstanceState;
		}

		public void onItemSelected(AdapterView<?> parent, View view,
				int position, long id) {
			if (parent.getCount() > position) {
				final Language selectedItem = (Language) parent
						.getItemAtPosition(position);
				LogUtils.LOGD(TAG, "onItemSelected " + selectedItem.getName());
				ArrayAdapter<String> adapter = new ArrayAdapter<String>(
						getActivity(), android.R.layout.simple_spinner_item,
						TranslationManager.getTypes(selectedItem));
				mSpinnerType.setAdapter(adapter);
				if (savedInstanceState != null) {
					if (savedInstanceState.containsKey(STATE_TYPE_POS)) {
						final int pos = savedInstanceState
								.getInt(STATE_TYPE_POS);
						if (mSpinnerType.getCount() > pos) {
							mSpinnerType.setSelection(pos);
						}
					}
				} else {
					Bundle extras = getActivity().getIntent().getExtras();
					if (extras != null) {
						int pos = extras.getInt(ID_TYPE, 0);
						if (mSpinnerType.getCount() > pos) {
							mSpinnerType.setSelection(pos);
						}
					} else {
						SharedPreferences settings = PreferenceManager
								.getDefaultSharedPreferences(getActivity());
						if (settings.contains(STATE_TYPE_POS)) {
							final int pos = settings.getInt(STATE_TYPE_POS, 0);
							if (mSpinnerType.getCount() > pos) {
								mSpinnerType.setSelection(pos);
							}
						}
					}
				}
			}
		}

		@Override
		public void onNothingSelected(AdapterView<?> arg0) {
			// TODO Auto-generated method stub
		}
	}

	/**
	 * Create a new instance of PreviewFragment
	 */
	public static PreviewFragment newInstance() {
		PreviewFragment f = new PreviewFragment();
		return f;
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			final Bundle savedInstanceState) {
		super.onCreateView(inflater, container, savedInstanceState);
		LogUtils.LOGD(TAG, "onCreateView >>");

		View view = inflater.inflate(R.layout.preview_fragment, container,
				false);
		LogUtils.LOGD(TAG, "onCreateView inflate done >>");
		getSherlockActivity().getSupportActionBar().setHomeButtonEnabled(false);
		getSherlockActivity().getSupportActionBar().setDisplayHomeAsUpEnabled(
				false);
		this.setRetainInstance(true);
		mTranslationFactory = new TranslationManager(this);
		mSpinnerLanguages = (Spinner) view.findViewById(R.id.spinner1);
		mSpinnerType = (Spinner) view.findViewById(R.id.spinner2);
		mTranslationView = (TextView) view.findViewById(R.id.webView1);
		mTranslationView.setMovementMethod(new ScrollingMovementMethod());
		mTextView = ((AutoCompleteTextView) view
				.findViewById(R.id.multiAutoCompleteTextView1));
		mOkButton = (Button) view.findViewById(R.id.button2);
		mCancelButton = (Button) view.findViewById(R.id.button1);
		mSpinnerLanguages.setAdapter(new LanguagesAdapter(getActivity(),
				TranslationManager.getLanguages()));
		mOkButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				doTranslate();
			}
		});
		mCancelButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				mTranslationFactory.stop();
			}
		});
		mSpinnerLanguages
				.setOnItemSelectedListener(new LanguageSelectedListener(
						savedInstanceState));
		mSpinnerType.setOnItemSelectedListener(new TypeSelectedListener());
		Bundle extras = getActivity().getIntent().getExtras();
		if (extras != null) {
			LogUtils.LOGD(TAG, "Intent " + extras.getString(ID_REQUEST) + " "
					+ extras.getInt(ID_LANGUAGE) + " " + extras.getInt(ID_TYPE));
			mTextView.setText(extras.getString(ID_REQUEST));
			mSpinnerLanguages.setSelection(extras.getInt(ID_LANGUAGE));
			int pos = extras.getInt(ID_TYPE);
			if (mSpinnerType.getCount() > pos) {
				mSpinnerType.setSelection(pos);
			}
		} else if (savedInstanceState != null) {
			LogUtils.LOGD(TAG, "savedInstanceState available");
			if (savedInstanceState.containsKey(STATE_TRANSLATE_VALUE)) {
				mTextView.setText(savedInstanceState
						.getString(STATE_TRANSLATE_VALUE));
			}
			if (savedInstanceState.containsKey(STATE_LANGUAGE_POS)) {
				mSpinnerLanguages.setSelection(savedInstanceState
						.getInt(STATE_LANGUAGE_POS));
			}
			if (savedInstanceState.containsKey(STATE_TYPE_POS)) {
				int pos = savedInstanceState.getInt(STATE_TYPE_POS);
				if (mSpinnerType.getCount() > pos) {
					mSpinnerType.setSelection(pos);
				}
			}
			if (savedInstanceState.containsKey(PreviewFragment.SHARED_DATA)) {
				mSharedData = savedInstanceState
						.getParcelable(PreviewFragment.SHARED_DATA);
			}
		} else {
			LogUtils.LOGD(TAG, "SharedPreferences available");
			SharedPreferences settings = PreferenceManager
					.getDefaultSharedPreferences(getActivity());
			if (settings.contains(STATE_TRANSLATE_VALUE)) {
				mTextView
						.setText(settings.getString(STATE_TRANSLATE_VALUE, ""));
			}
			if (settings.contains(STATE_LANGUAGE_POS)) {
				mSpinnerLanguages.setSelection(settings.getInt(
						STATE_LANGUAGE_POS, 0));
			}
			if (settings.contains(STATE_TYPE_POS)) {
				int pos = settings.getInt(STATE_TYPE_POS, 0);
				if (mSpinnerType.getCount() > pos){
					mSpinnerType.setSelection(pos);
				}
			}
		}
		if (mSharedData == null
				&& getArguments().containsKey(PreviewFragment.SHARED_DATA)) {
			LogUtils.LOGD(TAG, "getArguments available");
			mSharedData = getArguments().getParcelable(
					PreviewFragment.SHARED_DATA);
		}
		if (UIUtils.hasICS()) {
			mTranslationFactory.getAllWords();
		}
		if (mSharedData != null) {
			onFound(mSharedData);
		}
		getSherlockActivity().setSupportProgressBarIndeterminateVisibility(
				Boolean.FALSE);
		LogUtils.LOGD(TAG, "onCreateView <<");
		return view;
	}

	@Override
	public void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		LogUtils.LOGD(TAG, "onSaveInstanceState >>");
		if (mSpinnerLanguages != null && mSpinnerType != null
				&& mTextView != null) {
			outState.putString(STATE_TRANSLATE_VALUE, mTextView.getText()
					.toString());
			outState.putInt(STATE_LANGUAGE_POS,
					mSpinnerLanguages.getSelectedItemPosition());
			outState.putInt(STATE_TYPE_POS,
					mSpinnerType.getSelectedItemPosition());
			outState.putParcelable(PreviewFragment.SHARED_DATA, mSharedData);
		}
		LogUtils.LOGD(TAG, "onSaveInstanceState <<");
	}

	private void doTranslate() {
		LogUtils.LOGD(TAG, "doTranslate >>");
		showOnView(EMPTY_BODY);
		final String value = mTextView.getText().toString().trim();
		final Language selectedItem = (Language) mSpinnerLanguages
				.getSelectedItem();
		final int type = mSpinnerType.getSelectedItemPosition();
		mTranslationFactory.translate(value, type, selectedItem);
		LogUtils.LOGD(TAG, "doTranslate <<");
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		LogUtils.LOGD(TAG, "onConfigurationChanged >>");
		mTranslationFactory.stop();
		LogUtils.LOGD(TAG, "onConfigurationChanged >>");
	}

	@Override
	public void startProgress() {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(TAG, "startProgress >>");
					mOkButton.setEnabled(false);
					// if (UIUtils.hasICS()){
					getSherlockActivity()
							.setSupportProgressBarIndeterminateVisibility(
									Boolean.TRUE);
					// } else if (mProgressDialog!=null) {
					// mProgressDialog =
					// CustomProgressDialog.show(getSherlockActivity(), null,
					// "Loading...", true);
					// }
					LogUtils.LOGD(TAG, "startProgress <<");
				}
			});
		}
	}

	@Override
	public void stopProgress() {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(TAG, "stopProgress >>");
					if (mOkButton != null) {
						mOkButton.setEnabled(true);
					}
					// if (UIUtils.hasICS()){
					getSherlockActivity()
							.setSupportProgressBarIndeterminateVisibility(
									Boolean.FALSE);
					// } else if (mProgressDialog!=null) {
					// mProgressDialog.dismiss();
					// }
					LogUtils.LOGD(TAG, "stopProgress <<");
				}
			});
		}
	}

	@Override
	public void showOnView(final String content) {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(TAG, "showOnView size " + content.length()
							+ ">>");
					if (mTranslationView != null) {
						mTranslationView.scrollTo(0, 0);
						mTranslationView.setText(Html.fromHtml(content));
						// LogUtils.LOGD(TAG, content);
						// String test = content.replaceAll("<li>",
						// "<br>").replaceAll("</li>", "</br>");
						// LogUtils.LOGD(TAG,
						// Html.fromHtml(content).toString());
						// final String translateHtml =
						// XmlUtils.toHtml(content);
						// mWebView.loadData(translateHtml,
						// "text/html; charset=utf-8", "UTF-8");
					}
					LogUtils.LOGD(TAG, "showOnView <<");
				}
			});
		}
	}

	@Override
	public void onFoundVariants(final ArrayList<String> words) {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(TAG, "onFoundVariants size "
							+ ((words == null) ? "Null" : words.size()) + " >>");
					mSharedData = null;
					if (mTextView != null && words.size() > 0) {
						ArrayAdapter<String> adapter = new ArrayAdapter<String>(
								getActivity(),
								android.R.layout.simple_dropdown_item_1line,
								words);
						mTextView.setAdapter(adapter);
						adapter.notifyDataSetChanged();
					}
					getListener().onFoundVariants(words);
					LogUtils.LOGD(TAG, "onTranslateNotFound <<");
				}
			});
		}
	}

	@Override
	public void onFound(final Translation translation) {
		if (getActivity() != null) {
			getActivity().runOnUiThread(new Runnable() {
				public void run() {
					LogUtils.LOGD(
							TAG,
							"onTranslateFound size "
									+ ((translation.getTranslation() == null) ? "Null"
											: translation.getTranslation()
													.length()) + " >>");
					mSharedData = translation;
					showOnView(translation.getTranslation());
					getListener().onFound(translation);
					resetWordsSuggestions();
					LogUtils.LOGD(TAG, "onTranslateFound <<");
				}
			});
		}
	}

	@Override
	public void onAttach(Activity activity) {
		super.onAttach(activity);
		LogUtils.LOGD(TAG, "onAttach >>");
		try {
			mListener = (IUIListener) getSherlockActivity();
		} catch (ClassCastException e) {
			throw new ClassCastException(activity.toString()
					+ " must implement IUIListener");
		}
		LogUtils.LOGD(TAG, "onAttach <<");
	}

	@Override
	public void onDetach() {
		super.onDetach();
		LogUtils.LOGD(TAG, "onDetach");
		mListener = LexinActivity.sDummyListener;
	}

	@Override
	public void onPause() {
		super.onPause();
		LogUtils.LOGD(TAG, "onPause >>");
		stopProgress();
		mTranslationFactory.stop();
		if (mSpinnerLanguages != null && mSpinnerType != null
				&& mTextView != null) {
			SharedPreferences settings = PreferenceManager
					.getDefaultSharedPreferences(getActivity());
			SharedPreferences.Editor editor = settings.edit();
			editor.putString(STATE_TRANSLATE_VALUE, mTextView.getText()
					.toString());
			editor.putInt(STATE_LANGUAGE_POS,
					mSpinnerLanguages.getSelectedItemPosition());
			editor.putInt(STATE_TYPE_POS,
					mSpinnerType.getSelectedItemPosition());
			editor.commit();
		}
		LogUtils.LOGD(TAG, "onPause <<");
	}

	@Override
	public void onResume() {
		super.onResume();
		LogUtils.LOGD(TAG, "onResume >>");
		LogUtils.LOGD(TAG, "onResume <<");
	}

	@Override
	public void onFound(ArrayList<Translation> translations) {
		LogUtils.LOGE(TAG, "onFound");
	}

	@Override
	public void onFoundWords(ArrayList<String> words) {
		LogUtils.LOGE(TAG, "onFoundWords size=" + words.size());
		mSharedWords = words;
		resetWordsSuggestions();
	}

	@Override
	public void onNotFound(String message) {
		LogUtils.LOGE(TAG, "onNotFound");
		mSharedData = null;
		showOnView(message);
		getListener().onNotFound(message);
	}

	private void resetWordsSuggestions() {
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(getActivity(),
				android.R.layout.simple_dropdown_item_1line, mSharedWords);
		mTextView.setAdapter(adapter);
	}

	private IUIListener getListener() {
		return mListener;
	}

}
