/*
 * Copyright (C) 2012 Mykola Kondratenko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mykola.lexinproject.utils;

import java.util.ArrayList;

import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;

import android.text.Html;

import com.mykola.lexinproject.data.Translation;

public class XmlUtils {
	private static final String STRING_LYSSNA = "LYSSNA";
	private static final String STRING_MP3 = "mp3";
	private static final String STRING_FINNS = "finns:";
	private static final String TAG = "XmlUtils";

	public static ArrayList<String> getVariants(final TagNode root) {
		String variantsString = Html.fromHtml(toXml(root)).toString();
		LogUtils.LOGD(TAG, " >> " + variantsString);
		int variantsStart = variantsString.indexOf(STRING_FINNS);
		ArrayList<String> result = new ArrayList<String>();
		if (variantsStart > 0) {
			variantsString = variantsString.substring(variantsStart
					+ STRING_FINNS.length());
			String variants[] = variantsString.split(",");
			for (int i = 0; i < variants.length; i++) {
				result.add(variants[i].trim());
				LogUtils.LOGD(TAG, "getVariants '" + variants[i].trim() + "'");
			}
		}
		return result;
	}

	public static ArrayList<Translation.Attachment> getUrls(final Object[] root) {
		ArrayList<Translation.Attachment> urlArray = new ArrayList<Translation.Attachment>();
		for (int i = 0; i < root.length; i++) {
			TagNode node = (TagNode) root[i];
			LogUtils.LOGD(TAG, "getUrls " + toXml(node));
			final String url = node.getAttributes().get("href");
			LogUtils.LOGD(TAG, "url :" + url);
			if (url.endsWith(STRING_MP3)) {
				node = (TagNode) node.getChildren().get(0);
				ContentNode title = (ContentNode) node.getChildren().get(0);
				urlArray.add(new Translation.Attachment(title.toString(), url));
			}
		}
		return urlArray;
	}

	public static String toXml(final TagNode root) {
		final StringBuilder plain = new StringBuilder();
		if (root.hasChildren()) {
			int nodes = 0;
			int a = root.getChildren().size();
			while (nodes < a) {
				Object d = root.getChildren().get(nodes);
				if (d instanceof TagNode) {
					/*
					 * Log.e(TAG, "<" + d.toString()+">"); for
					 * (Entry<String,String> entrada : ((TagNode)
					 * d).getAttributes().entrySet()) { Log.e(TAG,
					 * entrada.getKey() +"  " +entrada.getValue() ); }
					 */
					//if (!d.toString().trim().equals("a")) {
						final TagNode c = (TagNode) root.getChildren().get(
								nodes);
						plain.append("<");
						plain.append(c.getName());
						plain.append(">");
						plain.append(toXml(c));
						plain.append("</");
						plain.append(c.getName());
						plain.append(">");
					//}
				} else if (d instanceof ContentNode) {
					// Log.e(TAG, "\"" + d.toString()+"\"");
					final ContentNode content = (ContentNode) root
							.getChildren().get(nodes);
					if (!content.toString().equalsIgnoreCase(STRING_LYSSNA)) {
						plain.append(content.toString());
					}
				} else {
					LogUtils.LOGE(TAG, "Unexpected tag " + "<" + d.toString()
							+ ">");
				}
				++nodes;
			}
		} else {
			plain.append(root.getText());
		}
		return plain.toString().replaceAll("<li>", "<br>")
				.replaceAll("</li>", "</br>");
	}

	public static String toHtml(final String translation) {
		final StringBuilder translate = new StringBuilder();
		translate.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
		translate.append("<html>");
		translate.append("<head>");
		translate
				.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />");
		translate.append("</head>");
		translate.append("<body>");
		translate.append(translation);
		translate.append("</body>");
		translate.append("</html>");
		return translate.toString();
	}
}
