/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.data;

import com.nolanlawson.japanesenamegenerator.v3.data.Condition;
import com.nolanlawson.japanesenamegenerator.v3.data.TransformingString;
import com.nolanlawson.japanesenamegenerator.v3.util.StringUtil;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    private int id = 0;
    private Set<Condition> conditions;
    private String currentValue;
    private String replacementValue;
    private transient Condition[] conditionsAsArray;
    private transient Integer hashCode;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Set<Condition> conditions) {
        this.conditions = conditions;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public String getReplacementValue() {
        return this.replacementValue;
    }

    public void setReplacementValue(String replacementValue) {
        this.replacementValue = replacementValue;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = Arrays.hashCode(this.hashableArray());
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof Rule && Arrays.equals(this.hashableArray(), ((Rule)other).hashableArray());
    }

    private Object[] hashableArray() {
        return new Object[]{this.currentValue, this.replacementValue, this.conditions};
    }

    public boolean applyToString(TransformingString transformingString) {
        String originalValue = transformingString.getOriginalValue();
        boolean changed = false;
        block0: for (int i = 0; i < originalValue.length(); ++i) {
            String currentReplacementValue = transformingString.currentValueAt(i);
            if (!currentReplacementValue.equals(this.currentValue)) continue;
            if (this.conditionsAsArray == null) {
                this.conditionsAsArray = this.conditions.toArray(new Condition[this.conditions.size()]);
            }
            for (int j = 0; j < this.conditionsAsArray.length; ++j) {
                Condition condition = this.conditionsAsArray[j];
                if (!this.conditionMet(condition, transformingString, i)) continue block0;
            }
            transformingString.setReplacementValue(i, this.replacementValue);
            transformingString.addRuleIdToRuleHistory(this.id);
            changed = true;
        }
        return changed;
    }

    private boolean conditionMet(Condition condition, TransformingString transformingString, int i) {
        String originalValue = transformingString.getOriginalValue();
        Object conditionValue = condition.getValue();
        boolean last = i == originalValue.length() - 1;
        boolean first = i == 0;
        switch (condition.getConditionType()) {
            case OriginalStringWas: {
                if (((Character)conditionValue).equals(Character.valueOf(originalValue.charAt(i)))) break;
                return false;
            }
            case EndOfString: {
                if ((!((Boolean)conditionValue).booleanValue() || last) && (((Boolean)conditionValue).booleanValue() || !last)) break;
                return false;
            }
            case StartOfString: {
                if ((!((Boolean)conditionValue).booleanValue() || first) && (((Boolean)conditionValue).booleanValue() || !first)) break;
                return false;
            }
            case FollowedByConsonant: {
                if (!((Boolean)conditionValue != false ? last || !StringUtil.isConsonant(originalValue.charAt(i + 1)) : !last && StringUtil.isConsonant(originalValue.charAt(i + 1)))) break;
                return false;
            }
            case PrecededByConsonant: {
                if (!((Boolean)conditionValue != false ? first || !StringUtil.isConsonantOrY(originalValue.charAt(i - 1)) : !first && StringUtil.isConsonantOrY(originalValue.charAt(i - 1)))) break;
                return false;
            }
            case NextChar: {
                if (!last && ((Character)conditionValue).equals(Character.valueOf(originalValue.charAt(i + 1)))) break;
                return false;
            }
            case PrevChar: {
                if (!first && ((Character)conditionValue).equals(Character.valueOf(originalValue.charAt(i - 1)))) break;
                return false;
            }
            case NextCharPlusOne: {
                if (i < originalValue.length() - 2 && ((Character)conditionValue).equals(Character.valueOf(originalValue.charAt(i + 2)))) break;
                return false;
            }
            case PrevCharPlusOne: {
                if (i >= 2 && ((Character)conditionValue).equals(Character.valueOf(originalValue.charAt(i - 2)))) break;
                return false;
            }
            case HadRuleApplied: {
                if (transformingString.hasRuleInRuleHistory((Integer)conditionValue)) break;
                return false;
            }
            case PrevCharIsFirst: {
                boolean prevCharIsFirst = (Boolean)conditionValue;
                if ((!prevCharIsFirst || i == 1) && (prevCharIsFirst || i != 1)) break;
                return false;
            }
            case NextCharIsLast: {
                boolean nextCharIsLast = (Boolean)conditionValue;
                if ((!nextCharIsLast || i == originalValue.length() - 2) && (nextCharIsLast || i != originalValue.length() - 2)) break;
                return false;
            }
            case NextCharPlusOneIsConsonant: {
                boolean nextCharPlusOneIsConsonant = (Boolean)conditionValue;
                if (!(nextCharPlusOneIsConsonant ? i >= originalValue.length() - 2 || !StringUtil.isConsonant(originalValue.charAt(i + 2)) : i < originalValue.length() - 2 && StringUtil.isConsonant(originalValue.charAt(i + 2)))) break;
                return false;
            }
            case NextString: {
                String nextString = (String)conditionValue;
                if (!last && nextString.equals(transformingString.currentValueAt(i + 1))) break;
                return false;
            }
            case PrevString: {
                String previousString = (String)conditionValue;
                if (!first && previousString.equals(transformingString.currentValueAt(i - 1))) break;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Rule: '" + this.currentValue + "' --> '" + this.replacementValue + "' where " + this.conditions;
    }
}

