/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.util;

import com.nolanlawson.japanesenamegenerator.v3.util.ArrayUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerSet
implements Iterable<Integer> {
    private static final int DEFAULT_SIZE = 25;
    private boolean[] values;

    public IntegerSet() {
        this.values = new boolean[25];
    }

    public IntegerSet(int idx) {
        this.values = new boolean[idx + 1];
        this.values[idx] = true;
    }

    public IntegerSet(IntegerSet other) {
        this.values = ArrayUtil.copyOf(other.values, other.values.length);
    }

    public IntegerSet(Set<Character> other) {
        this.values = new boolean[25];
        for (Character ch : other) {
            this.add(ch.charValue());
        }
    }

    public void add(int i) {
        if (i >= this.values.length) {
            int newSize = Math.max(this.values.length * 2, i + 1);
            this.values = ArrayUtil.copyOf(this.values, newSize);
        }
        this.values[i] = true;
    }

    public boolean contains(int i) {
        return i < this.values.length && this.values[i];
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                while (this.idx < IntegerSet.this.values.length && !IntegerSet.this.values[this.idx]) {
                    ++this.idx;
                }
                return this.idx < IntegerSet.this.values.length;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.idx;
                return this.idx - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }
}

