/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.util;

import com.nolanlawson.japanesenamegenerator.v3.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightweightIntegerMap
implements Map<Integer, Integer> {
    private static final int INITIAL_SIZE = 32;
    private int startIdx;
    private int[] values;
    private boolean[] filled;

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Integer get(Object key) {
        Integer intKey = (Integer)key;
        if (this.filled == null) {
            return null;
        }
        if (intKey - this.startIdx < this.filled.length && intKey >= this.startIdx && this.filled[intKey - this.startIdx]) {
            return this.values[intKey - this.startIdx];
        }
        return null;
    }

    @Override
    public Integer put(Integer key, Integer value) {
        if (this.values == null) {
            this.values = new int[32];
            this.filled = new boolean[32];
            this.startIdx = key;
        } else if (key < this.startIdx) {
            int lengthToAdd = this.startIdx - key;
            int[] intArrayToAdd = new int[lengthToAdd];
            boolean[] boolArrayToAdd = new boolean[lengthToAdd];
            this.filled = ArrayUtil.concatenate(boolArrayToAdd, this.filled);
            this.values = ArrayUtil.concatenate(intArrayToAdd, this.values);
            this.startIdx = key;
        } else if (key - this.startIdx >= this.values.length) {
            int newSize = Math.max(key - this.startIdx + 1, this.values.length * 2);
            this.values = ArrayUtil.copyOf(this.values, newSize);
            this.filled = ArrayUtil.copyOf(this.filled, newSize);
        }
        this.filled[key.intValue() - this.startIdx] = true;
        this.values[key.intValue() - this.startIdx] = value;
        return null;
    }

    @Override
    public Integer remove(Object key) {
        Integer intKey = (Integer)key;
        if (intKey >= this.startIdx && intKey - this.startIdx < this.filled.length) {
            this.filled[intKey.intValue() - this.startIdx] = false;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Integer> keySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<Integer> values() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.filled[i]) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

