/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.util;

import java.lang.ref.SoftReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static Map<Set<CharSequence>, SoftReference<Integer>> editDistanceCache = new HashMap<Set<CharSequence>, SoftReference<Integer>>();
    public static final Set<Character> consonants = new HashSet<Character>(Arrays.asList(Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')));
    public static final Set<Character> vowels = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')));

    private static Integer getFromCache(CharSequence str1, CharSequence str2) {
        PairSet<CharSequence> key = new PairSet<CharSequence>(str1, str2);
        SoftReference<Integer> softReference = editDistanceCache.get(key);
        return softReference != null ? softReference.get() : null;
    }

    private static void putInCache(CharSequence str1, CharSequence str2, int editDistance) {
        StringBuilder sb1 = new StringBuilder(str1);
        sb1.trimToSize();
        StringBuilder sb2 = new StringBuilder(str2);
        sb2.trimToSize();
        PairSet<StringBuilder> key = new PairSet<StringBuilder>(sb1, sb2);
        editDistanceCache.put(key, new SoftReference<Integer>(editDistance));
    }

    public static String quickReplace(String originalString, String searchString, String replaceString) {
        StringBuffer sb = new StringBuffer(originalString);
        int index = sb.indexOf(searchString);
        while (index != -1) {
            sb.replace(index, index + searchString.length(), replaceString);
            index += replaceString.length();
            index = sb.indexOf(searchString, index);
        }
        return sb.toString();
    }

    public static List<String> splitIntoJapaneseSyllables(String str) {
        if (str.equals("")) {
            throw new RuntimeException("string can't be empty: " + str);
        }
        ArrayList prelimResult = new ArrayList();
        boolean lastCharWasVowel = false;
        char[] charArray = str.toCharArray();
        ArrayList<Character> currentSubsequence = new ArrayList<Character>();
        for (int i = 0; i < charArray.length; ++i) {
            char ch = charArray[i];
            boolean bl = vowels.contains(Character.valueOf(ch));
            if (i > 0) {
                if (!bl) {
                    if ((lastCharWasVowel || ch != 'y') && (lastCharWasVowel || charArray[i - 1] == 'n' || ch == "'".charAt(0) || ch == 'n' && (lastCharWasVowel || charArray[i - 1] == 'n'))) {
                        prelimResult.add(currentSubsequence);
                        currentSubsequence = new ArrayList();
                    }
                } else if (ch == 'a' && charArray[i - 1] == 'e' || ch == 'a' && charArray[i - 1] == 'i' || ch == 'a' && charArray[i - 1] == 'u') {
                    prelimResult.add(currentSubsequence);
                    currentSubsequence = new ArrayList();
                }
            }
            if (ch != "'".charAt(0)) {
                currentSubsequence.add(Character.valueOf(ch));
            }
            lastCharWasVowel = bl;
        }
        prelimResult.add(currentSubsequence);
        ArrayList<String> result = new ArrayList<String>();
        for (List list : prelimResult) {
            char[] currCharArray = new char[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                currCharArray[i] = ((Character)list.get(i)).charValue();
            }
            result.add(new String(currCharArray));
        }
        return result;
    }

    private static int findCommonPrefixLength(CharSequence str1, CharSequence str2) {
        int length = Math.min(str1.length(), str2.length());
        for (int i = 0; i < length; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            return i;
        }
        return 0;
    }

    private static int findCommonSuffixLength(CharSequence str1, CharSequence str2, int commonPrefixLength) {
        int length = Math.min(str1.length(), str2.length());
        for (int i = 0; i < length - commonPrefixLength; ++i) {
            if (str1.charAt(str1.length() - i - 1) == str2.charAt(str2.length() - i - 1)) continue;
            return i;
        }
        return 0;
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int computeLevenshteinDistance(CharSequence str1, CharSequence str2) {
        int i;
        int commonPrefixLength = Util.findCommonPrefixLength(str1, str2);
        if (commonPrefixLength == str1.length() && commonPrefixLength == str2.length()) {
            return 0;
        }
        int commonSuffixLength = Util.findCommonSuffixLength(str1, str2, commonPrefixLength);
        str1 = str1.subSequence(commonPrefixLength, str1.length() - commonSuffixLength);
        str2 = str2.subSequence(commonPrefixLength, str2.length() - commonSuffixLength);
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = Util.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        int dist = distance[str1.length()][str2.length()];
        return dist;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairSet<E>
    extends AbstractSet<E> {
        private E first;
        private E second;
        private int hashCode;

        public PairSet(E first, E second) {
            this.first = first;
            this.second = second;
            this.hashCode = (0x11 ^ first.hashCode()) + (0x11 ^ second.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PairSet other = (PairSet)obj;
            return this.first.equals(other.first) && this.second.equals(other.second) || this.second.equals(other.first) && this.first.equals(other.second);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int size() {
            return 2;
        }
    }
}

