/*
Copyright (C) 2016 Thomas Hauth. All Rights Reserved.
* Written by Thomas Hauth (Thomas.Hauth@web.de)

This file is part of Kung Foo Barracuda.

Kung Foo Barracuda is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Kung Foo Barracuda is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Kung Foo Barracuda.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include <DescentEngine/src/Cpp11.h>
#include <DescentEngine/src/Log.h>
#include <DescentEngine/src/StateEngine/Aspect.h>

#include <DescentEngine/src/Input/InputContainer.h>

// translates the content of an InputContainer
// to the signals of a game state

template<class TState>
class DebugFunctionAspect: public Aspect<TState> {
public:
	DebugFunctionAspect() {
	}

	virtual ~DebugFunctionAspect() {
	}

	virtual void init(TState & gs) CPP11_OVERRIDE
	{
		gs.slotDebugSwitchRenderTiles.subscribe([] ( TState & g, bool b)
		{/*
		 if (g.getEngines().inputEngine().any_keyDownExit().first) {
		 g.requestApplicationQuit();
		 }*/
			g.getEngines().renderEngine().setDebugFaces(
					! g.getEngines().renderEngine().getDebugFaces( ));

		});
	}

};
