/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.util.Base64;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tv.ouya.console.api.Product;
import tv.ouya.console.api.Receipt;
import tv.ouya.console.internal.util.OuyaDateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuyaEncryptionHelper {
    public List<Receipt> decryptReceiptResponse(JSONObject encryptedResponse, PublicKey appKey) throws GeneralSecurityException, IOException, JSONException, ParseException {
        if (!(encryptedResponse.has("key") && encryptedResponse.has("iv") && encryptedResponse.has("blob"))) {
            throw new RuntimeException("Invalid response from server");
        }
        String base64Data = encryptedResponse.getString("key").trim();
        byte[] keyData = Base64.decode((String)base64Data, (int)0);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(2, appKey);
        byte[] keyBytes = cipher.doFinal(keyData);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        base64Data = encryptedResponse.getString("iv").trim();
        byte[] ivBytes = Base64.decode((String)base64Data, (int)0);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        String payloadString = encryptedResponse.getString("blob").trim();
        byte[] payload = Base64.decode((String)payloadString, (int)0);
        cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)key, iv);
        byte[] encryptedReceipts = cipher.doFinal(payload);
        JSONObject purchasesWrapper = new JSONObject(new String(encryptedReceipts, "UTF-8"));
        return this.parseJSONReceiptResponse(purchasesWrapper.getJSONArray("purchases"));
    }

    public String decryptPurchaseResponse(JSONObject encryptedResponse, PublicKey appKey) throws GeneralSecurityException, IOException, JSONException, ParseException {
        if (!(encryptedResponse.has("key") && encryptedResponse.has("iv") && encryptedResponse.has("blob"))) {
            throw new RuntimeException("Invalid response from server");
        }
        String base64Data = encryptedResponse.getString("key");
        byte[] keyData = Base64.decode((String)base64Data, (int)0);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(2, appKey);
        byte[] keyBytes = cipher.doFinal(keyData);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        base64Data = encryptedResponse.getString("iv");
        byte[] ivBytes = Base64.decode((String)base64Data, (int)0);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        String payloadString = encryptedResponse.getString("blob");
        byte[] payload = Base64.decode((String)payloadString, (int)0);
        cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)key, iv);
        byte[] encryptedReceipts = cipher.doFinal(payload);
        JSONObject response = new JSONObject(new String(encryptedReceipts, "UTF-8"));
        if (response.has("uuid")) {
            return response.getString("uuid");
        }
        return null;
    }

    public List<Receipt> parseJSONReceiptResponse(String receiptResponse) throws IOException {
        try {
            if (!receiptResponse.contains("ENCRYPTED")) {
                return this.parseJSONReceiptResponse(new JSONArray(receiptResponse));
            }
            receiptResponse = receiptResponse.replace("ENCRYPTED", "");
            JSONObject purchasesWrapper = new JSONObject(receiptResponse);
            return this.parseJSONReceiptResponse(purchasesWrapper.getJSONArray("purchases"));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public List<Receipt> parseJSONReceiptResponse(JSONArray receiptArray) throws JSONException, ParseException {
        ArrayList<Receipt> receipts = new ArrayList<Receipt>(receiptArray.length());
        OuyaDateParser odp = new OuyaDateParser();
        for (int i = 0; i < receiptArray.length(); ++i) {
            receipts.add(this.createReceipt(odp, receiptArray.getJSONObject(i)));
        }
        return receipts;
    }

    public static Product decryptProductResponse(String encryptedResponse, byte[] appKey) throws GeneralSecurityException, IOException, JSONException {
        byte[] encryptedReceiptResponse = Base64.decode((String)encryptedResponse, (int)0);
        if (encryptedReceiptResponse[0] != 1) {
            throw new InvalidParameterException("The receipt is encrypted using a system which is unknown");
        }
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(appKey);
        PrivateKey privateRSAKey = factory.generatePrivate(keySpec);
        byte keySize = encryptedReceiptResponse[1];
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateRSAKey);
        byte[] decryptedKey = cipher.doFinal(encryptedReceiptResponse, 1, keySize);
        SecretKeySpec aesKeySpec = new SecretKeySpec(decryptedKey, "AES");
        cipher = Cipher.getInstance("AES");
        cipher.init(2, aesKeySpec);
        byte[] decryptedData = cipher.doFinal(encryptedReceiptResponse, keySize + 2, encryptedReceiptResponse.length);
        String receiptResponse = new String(decryptedData, "UTF-8");
        return new Product(new JSONObject(receiptResponse));
    }

    private Receipt createReceipt(OuyaDateParser odp, JSONObject receipt) throws JSONException, ParseException {
        Date generatedDate;
        String dateField = "purchaseDate";
        Date date = receipt.has(dateField) ? new Date(receipt.getLong(dateField)) : odp.parse(receipt.getString("date"));
        dateField = "generateDate";
        if (receipt.has(dateField)) {
            generatedDate = new Date(receipt.getLong(dateField));
        } else {
            generatedDate = new Date();
            generatedDate.setTime(0L);
        }
        String productId = receipt.optString("identifier");
        if (productId.isEmpty()) {
            productId = receipt.getString("sku");
        }
        return new Receipt(productId, receipt.getInt("priceInCents"), date, generatedDate);
    }
}

