/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OuyaController {
    public static final int BUTTON_O = 96;
    public static final int BUTTON_U = 99;
    public static final int BUTTON_Y = 100;
    public static final int BUTTON_A = 97;
    public static final int BUTTON_L1 = 102;
    public static final int BUTTON_L2 = 104;
    public static final int BUTTON_R1 = 103;
    public static final int BUTTON_R2 = 105;
    public static final int BUTTON_MENU = 82;
    public static final int AXIS_LS_X = 0;
    public static final int AXIS_LS_Y = 1;
    public static final int AXIS_RS_X = 11;
    public static final int AXIS_RS_Y = 14;
    public static final int AXIS_L2 = 17;
    public static final int AXIS_R2 = 18;
    public static final int BUTTON_DPAD_UP = 19;
    public static final int BUTTON_DPAD_RIGHT = 22;
    public static final int BUTTON_DPAD_DOWN = 20;
    public static final int BUTTON_DPAD_LEFT = 21;
    public static final int BUTTON_R3 = 107;
    public static final int BUTTON_L3 = 106;
    private static int[] AVAILABLE_AXES = new int[]{0, 1, 11, 14, 17, 18};
    public static final int MAX_CONTROLLERS = 4;
    public static final float STICK_DEADZONE = 0.25f;
    private static final String OUYA_CONTROLLER_ADDED_ACTION = "tv.ouya.controller.added";
    private static final String OUYA_CONTROLLER_REMOVED_ACTION = "tv.ouya.controller.removed";
    private static final String EXTRA_OUYA_CONTROLLER_DEVICE_ID = "DEVICE_ID";
    private static final String EXTRA_OUYA_CONTROLLER_PLAYER_NUM = "PLAYER_NUM";
    private static final int INVALID_INPUT_DEVICE_ID = -1;
    private static Context appContext;
    static OuyaController[] s_controllers;
    private static final String ROCK_CANDY_ID = "Generic X-Box pad";
    private static final String OUYA_ID = "OUYA Game Controller";
    private static final Map<String, SparseIntArray> s_buttonByDeviceName;
    private static final Map<String, SparseIntArray> s_axisByDeviceName;
    private int deviceId;
    private InputDevice device;
    private SparseArray<Float> axisValues;
    private SparseBooleanArray buttonValues;
    private SparseBooleanArray thisFrameButtonValues;
    private SparseIntArray deviceAxis;
    private SparseIntArray deviceKeycodes;

    public static void init(Context context) {
        if (appContext != null) {
            return;
        }
        appContext = context.getApplicationContext();
        for (int i = 0; i < 4; ++i) {
            int deviceId = OuyaController.getDeviceIdFromPlayerNum(i);
            if (deviceId == -1) continue;
            OuyaController.getOrCreateControllerByDeviceId(deviceId);
        }
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals(OuyaController.OUYA_CONTROLLER_ADDED_ACTION)) {
                    int deviceId = intent.getIntExtra(OuyaController.EXTRA_OUYA_CONTROLLER_DEVICE_ID, -1);
                    int playerNum = intent.getIntExtra(OuyaController.EXTRA_OUYA_CONTROLLER_PLAYER_NUM, -1);
                    if (playerNum < 0 || playerNum >= 4) {
                        return;
                    }
                    if (s_controllers[playerNum] != null) {
                        Log.e((String)"OuyaController", (String)("Controller already exists for player " + playerNum + "(new device id " + deviceId + ", prev device id " + s_controllers[playerNum].getDeviceId() + ")"));
                    }
                    OuyaController.s_controllers[playerNum] = new OuyaController(deviceId);
                } else if (intent.getAction().equals(OuyaController.OUYA_CONTROLLER_REMOVED_ACTION)) {
                    int deviceId = intent.getIntExtra(OuyaController.EXTRA_OUYA_CONTROLLER_DEVICE_ID, -1);
                    for (int i = 0; i < 4; ++i) {
                        OuyaController controller = s_controllers[i];
                        if (controller == null || controller.getDeviceId() != deviceId) continue;
                        OuyaController.s_controllers[i] = null;
                        break;
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction(OUYA_CONTROLLER_ADDED_ACTION);
        filter.addAction(OUYA_CONTROLLER_REMOVED_ACTION);
        appContext.registerReceiver(receiver, filter);
    }

    public static OuyaController getControllerByDeviceId(int deviceId) {
        for (OuyaController c : s_controllers) {
            if (c == null || c.getDeviceId() != deviceId) continue;
            return c;
        }
        return null;
    }

    public static int getPlayerNumByDeviceId(int deviceId) {
        OuyaController controller = OuyaController.getOrCreateControllerByDeviceId(deviceId);
        if (controller == null) {
            return -1;
        }
        return controller.getPlayerNum();
    }

    public static OuyaController getControllerByPlayer(int playerNum) {
        if (s_controllers != null && playerNum >= 0 && playerNum < 4) {
            return s_controllers[playerNum];
        }
        return null;
    }

    public static boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 0x10) == 0) {
            return false;
        }
        if (event.getAction() != 2) {
            return false;
        }
        OuyaController device = OuyaController.getOrCreateControllerByDeviceId(event.getDeviceId());
        if (device == null) {
            return false;
        }
        for (int ouyaAxis : AVAILABLE_AXES) {
            int nativeAxis = device.mapAxis(ouyaAxis);
            if (nativeAxis < 0) continue;
            Float curValue = (Float)device.axisValues.get(ouyaAxis);
            float newValue = event.getAxisValue(nativeAxis);
            if (curValue != null && curValue.floatValue() == newValue) continue;
            device.axisValues.put(ouyaAxis, (Object)Float.valueOf(newValue));
        }
        return true;
    }

    public static boolean onKeyDown(int keyCode, KeyEvent event) {
        return OuyaController.onKeyEvent(keyCode, event);
    }

    public static boolean onKeyUp(int keyCode, KeyEvent event) {
        return OuyaController.onKeyEvent(keyCode, event);
    }

    private static boolean onKeyEvent(int keyCode, KeyEvent event) {
        OuyaController device = OuyaController.getOrCreateControllerByDeviceId(event.getDeviceId());
        if (device == null) {
            return false;
        }
        int ouyaButton = device.mapKeyCode(event);
        if (ouyaButton < 0) {
            return false;
        }
        boolean newVal = false;
        switch (event.getAction()) {
            case 0: 
            case 2: {
                newVal = true;
                break;
            }
            case 1: {
                newVal = false;
            }
        }
        device.buttonValues.put(ouyaButton, newVal);
        device.thisFrameButtonValues.put(ouyaButton, newVal);
        return true;
    }

    public static void startOfFrame() {
        for (OuyaController c : s_controllers) {
            c.startOfFrameInternal();
        }
    }

    private void startOfFrameInternal() {
        for (OuyaController device : s_controllers) {
            device.thisFrameButtonValues.clear();
        }
    }

    public boolean buttonChangedThisFrame(int ouyaButton) {
        return this.thisFrameButtonValues.indexOfKey(ouyaButton) >= 0;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public float getAxisValue(int ouyaAxis) {
        if (this.axisValues.indexOfKey(ouyaAxis) >= 0) {
            Float value = (Float)this.axisValues.get(ouyaAxis);
            return value.floatValue();
        }
        return 0.0f;
    }

    public boolean getButton(int ouyaButton) {
        if (this.buttonValues.indexOfKey(ouyaButton) >= 0) {
            boolean value = this.buttonValues.get(ouyaButton);
            return value;
        }
        return false;
    }

    public int getPlayerNum() {
        for (int i = 0; i < 4; ++i) {
            if (s_controllers[i] != this) continue;
            return i;
        }
        return -1;
    }

    private static SparseIntArray getButtonMap(InputDevice device) {
        String deviceName = device != null ? device.getName() : OUYA_ID;
        SparseIntArray deviceButton = s_buttonByDeviceName.get(deviceName);
        if (deviceButton == null) {
            deviceButton = s_buttonByDeviceName.get(OUYA_ID);
        }
        return deviceButton;
    }

    private static SparseIntArray getAxisMap(InputDevice device) {
        String deviceName = device != null ? device.getName() : OUYA_ID;
        SparseIntArray deviceAxis = s_axisByDeviceName.get(deviceName);
        if (deviceAxis == null) {
            deviceAxis = s_axisByDeviceName.get(OUYA_ID);
        }
        return deviceAxis;
    }

    private static OuyaController getOrCreateControllerByDeviceId(int deviceId) {
        OuyaController c = OuyaController.getControllerByDeviceId(deviceId);
        if (c != null) {
            return c;
        }
        if (s_controllers != null) {
            int playerNum = OuyaController.getPlayerNumFromDeviceId(deviceId);
            if (playerNum < 0 || playerNum >= 4) {
                return null;
            }
            if (s_controllers[playerNum] != null) {
                Log.e((String)"OuyaController", (String)("Controller for player " + playerNum + " already found, but doesn't match device id " + "(expected " + deviceId + " got " + s_controllers[playerNum].getDeviceId() + ")"));
                return s_controllers[playerNum];
            }
            OuyaController.s_controllers[playerNum] = new OuyaController(deviceId);
            return s_controllers[playerNum];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDeviceIdFromPlayerNum(int playerNum) {
        Uri controllerUri = Uri.parse((String)"content://tv.ouya.controllerdata/");
        Cursor cursor = appContext.getContentResolver().query(controllerUri, new String[]{"input_device_id"}, "player_num = ?", new String[]{String.valueOf(playerNum)}, null);
        try {
            if (cursor != null && cursor.moveToNext()) {
                int deviceId;
                int n = deviceId = cursor.getInt(0);
                return n;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPlayerNumFromDeviceId(int deviceId) {
        if (appContext == null) {
            return -1;
        }
        Uri controllerUri = Uri.parse((String)"content://tv.ouya.controllerdata/");
        Cursor cursor = appContext.getContentResolver().query(controllerUri, new String[]{"player_num"}, "input_device_id = ?", new String[]{String.valueOf(deviceId)}, null);
        try {
            if (cursor != null && cursor.moveToNext()) {
                int playerNum;
                int n = playerNum = cursor.getInt(0);
                return n;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return -1;
    }

    OuyaController(int deviceId) {
        this.deviceId = deviceId;
        this.device = InputDevice.getDevice((int)deviceId);
        this.axisValues = new SparseArray();
        this.buttonValues = new SparseBooleanArray();
        this.thisFrameButtonValues = new SparseBooleanArray();
        this.deviceAxis = OuyaController.getAxisMap(this.device);
        this.deviceKeycodes = OuyaController.getButtonMap(this.device);
    }

    private int mapKeyCode(KeyEvent keyEvent) {
        if (this.deviceKeycodes.indexOfKey(keyEvent.getKeyCode()) < 0) {
            return -1;
        }
        int interpretedKeycode = this.deviceKeycodes.get(keyEvent.getKeyCode());
        return interpretedKeycode;
    }

    private int mapAxis(int axis) {
        if (this.deviceAxis.indexOfKey(axis) < 0) {
            return -1;
        }
        int interpretedAxis = this.deviceAxis.get(axis);
        return interpretedAxis;
    }

    static {
        s_controllers = new OuyaController[4];
        SparseIntArray rockCandyButtonMap = new SparseIntArray();
        rockCandyButtonMap.put(96, 96);
        rockCandyButtonMap.put(99, 99);
        rockCandyButtonMap.put(100, 100);
        rockCandyButtonMap.put(97, 97);
        rockCandyButtonMap.put(102, 102);
        rockCandyButtonMap.put(104, 104);
        rockCandyButtonMap.put(106, 106);
        rockCandyButtonMap.put(103, 103);
        rockCandyButtonMap.put(105, 105);
        rockCandyButtonMap.put(107, 107);
        rockCandyButtonMap.put(20, 20);
        rockCandyButtonMap.put(19, 19);
        rockCandyButtonMap.put(22, 22);
        rockCandyButtonMap.put(21, 21);
        rockCandyButtonMap.put(108, 82);
        SparseIntArray ouyaButtonMap = new SparseIntArray();
        ouyaButtonMap.put(96, 96);
        ouyaButtonMap.put(99, 99);
        ouyaButtonMap.put(100, 100);
        ouyaButtonMap.put(97, 97);
        ouyaButtonMap.put(102, 102);
        ouyaButtonMap.put(104, 104);
        ouyaButtonMap.put(106, 106);
        ouyaButtonMap.put(103, 103);
        ouyaButtonMap.put(105, 105);
        ouyaButtonMap.put(107, 107);
        ouyaButtonMap.put(20, 20);
        ouyaButtonMap.put(19, 19);
        ouyaButtonMap.put(22, 22);
        ouyaButtonMap.put(21, 21);
        ouyaButtonMap.put(82, 82);
        HashMap<String, SparseIntArray> buttonByDevice = new HashMap<String, SparseIntArray>();
        buttonByDevice.put(ROCK_CANDY_ID, rockCandyButtonMap);
        buttonByDevice.put(OUYA_ID, ouyaButtonMap);
        s_buttonByDeviceName = Collections.unmodifiableMap(buttonByDevice);
        SparseIntArray rockCandyAxisMap = new SparseIntArray();
        rockCandyAxisMap.put(0, 0);
        rockCandyAxisMap.put(1, 1);
        rockCandyAxisMap.put(11, 11);
        rockCandyAxisMap.put(14, 14);
        rockCandyAxisMap.put(17, 17);
        rockCandyAxisMap.put(18, 18);
        SparseIntArray ouyaAxisMap = new SparseIntArray();
        ouyaAxisMap.put(0, 0);
        ouyaAxisMap.put(1, 1);
        ouyaAxisMap.put(11, 11);
        ouyaAxisMap.put(14, 14);
        ouyaAxisMap.put(17, 17);
        ouyaAxisMap.put(18, 18);
        HashMap<String, SparseIntArray> axisByDevice = new HashMap<String, SparseIntArray>();
        axisByDevice.put(ROCK_CANDY_ID, rockCandyAxisMap);
        axisByDevice.put(OUYA_ID, ouyaAxisMap);
        s_axisByDeviceName = Collections.unmodifiableMap(axisByDevice);
    }
}

