/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import tv.ouya.console.api.OuyaResponseListener;
import tv.ouya.console.api.Product;
import tv.ouya.console.api.Purchasable;
import tv.ouya.console.api.RequestRunnable;
import tv.ouya.console.internal.IIapServiceDefinition;
import tv.ouya.console.internal.ProductListListenerBinder;
import tv.ouya.console.internal.StringListenerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuyaFacade
implements ServiceConnection {
    private static final String LOG_TAG = "OUYAF";
    private static final String[] USER_DATA_COLUMNS = new String[]{"value"};
    static final int ODK_VERSION_NUMBER = 40;
    private static OuyaFacade instance = new OuyaFacade();
    private Context context;
    private IIapServiceDefinition remoteService;
    private List<Runnable> pendingRequests = new ArrayList<Runnable>();
    private boolean bindRequestHasBeenMade;
    private String developerId;

    public static OuyaFacade getInstance() {
        return instance;
    }

    public static int getOdkVersionNumber() {
        return 40;
    }

    @Deprecated
    static void setInstance(OuyaFacade instance) {
        OuyaFacade.instance = instance;
    }

    OuyaFacade() {
        Log.v((String)LOG_TAG, (String)"ODK version number: 40");
    }

    public void init(Context context, String developerId) {
        if (this.isInitialized()) {
            return;
        }
        this.context = context.getApplicationContext();
        this.developerId = developerId;
    }

    public void shutdown() {
        if (this.context != null) {
            if (this.remoteService != null) {
                this.context.unbindService((ServiceConnection)this);
                this.remoteService = null;
                this.bindRequestHasBeenMade = false;
            }
            this.context = null;
        }
    }

    public boolean isInitialized() {
        return this.context != null;
    }

    public boolean isRunningOnOUYAHardware() {
        boolean runningOnOuya;
        boolean bl = runningOnOuya = "cardhu".equals(Build.DEVICE) || "ouya_1_1".equals(Build.DEVICE);
        if (!runningOnOuya) {
            Log.w((String)LOG_TAG, (String)("Not running on Ouya hardware: " + Build.DEVICE));
        }
        return runningOnOuya;
    }

    public void setTestMode() {
        SetTestModeRunnable setTestModeRunnable = new SetTestModeRunnable();
        this.runRequest(setTestModeRunnable);
    }

    public void putGameData(String name, String value) {
        ContentValues cv = new ContentValues();
        cv.put("value", value);
        this.context.getContentResolver().insert(Uri.parse((String)("content://tv.ouya.userdata/settings/" + name)), cv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGameData(String name) {
        Cursor results = this.context.getContentResolver().query(Uri.parse((String)("content://tv.ouya.userdata/settings/" + name)), USER_DATA_COLUMNS, null, null, null, null);
        try {
            if (results.moveToNext()) {
                String string = results.getString(0);
                return string;
            }
        }
        finally {
            results.close();
        }
        return null;
    }

    public void requestProductList(List<Purchasable> purchasables, OuyaResponseListener<ArrayList<Product>> productListListener) {
        RequestProductListRunnable requestProductListRunnable = new RequestProductListRunnable(purchasables, productListListener);
        this.runRequest(requestProductListRunnable);
    }

    public void requestPurchase(Purchasable purchasable, OuyaResponseListener<String> purchaseListener) {
        RequestPurchaseRunnable requestProductListRunnable = new RequestPurchaseRunnable(purchasable, purchaseListener);
        this.runRequest(requestProductListRunnable);
    }

    public void requestReceipts(OuyaResponseListener<String> receiptListListener) {
        this.runRequest(new RequestReceiptsRunnable(receiptListListener));
    }

    public void requestGamerUuid(OuyaResponseListener<String> gamerUuidListener) {
        this.runRequest(new RequestGamerUuidRunnable(gamerUuidListener));
    }

    private void runRequest(Runnable requestRunnable) {
        this.ensureServiceIsBound();
        if (this.remoteService != null) {
            requestRunnable.run();
        } else {
            this.pendingRequests.add(requestRunnable);
        }
    }

    @Deprecated
    IIapServiceDefinition getRemoteService() {
        return this.remoteService;
    }

    @Deprecated
    public boolean bindRequestHasBeenMade() {
        return this.bindRequestHasBeenMade;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Log.d((String)"inAppPurchase", (String)"Successfully bound to IapService");
        this.remoteService = IIapServiceDefinition.Stub.asInterface(iBinder);
        while (this.pendingRequests.size() > 0) {
            this.pendingRequests.remove(0).run();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.remoteService = null;
        this.bindRequestHasBeenMade = false;
    }

    void ensureServiceIsBound() {
        if (this.context == null) {
            Log.e((String)LOG_TAG, (String)"Dropping request because connect has been shut down");
            return;
        }
        if (!this.bindRequestHasBeenMade) {
            Log.d((String)"inAppPurchase", (String)"Binding to IapService");
            Intent intent = new Intent();
            intent.setClassName("tv.ouya", "tv.ouya.console.service.iap.IapService");
            this.context.bindService(intent, (ServiceConnection)this, 1);
            this.bindRequestHasBeenMade = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestGamerUuidRunnable
    extends RequestRunnable {
        public RequestGamerUuidRunnable(OuyaResponseListener<String> gamerUuidListener) {
            super(gamerUuidListener, "fetching gamer UUID");
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestGamerUuid(OuyaFacade.this.developerId, new StringListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestReceiptsRunnable
    extends RequestRunnable {
        private RequestReceiptsRunnable(OuyaResponseListener<String> listener) {
            super(listener, "fetching receipts");
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestReceipts(OuyaFacade.this.developerId, new StringListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestPurchaseRunnable
    extends RequestRunnable {
        private final Purchasable purchasable;

        public RequestPurchaseRunnable(Purchasable purchasable, OuyaResponseListener<String> purchaseListener) {
            super(purchaseListener, "purchasing");
            this.purchasable = purchasable;
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestPurchase(OuyaFacade.this.developerId, this.purchasable, new StringListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestProductListRunnable
    extends RequestRunnable {
        private final List<Purchasable> purchasables;

        public RequestProductListRunnable(List<Purchasable> purchasables, OuyaResponseListener<ArrayList<Product>> productListListener) {
            super(productListListener, "fetching product list");
            this.purchasables = purchasables;
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestProductList(OuyaFacade.this.developerId, this.purchasables, new ProductListListenerBinder(this.listener));
        }
    }

    private class SetTestModeRunnable
    extends RequestRunnable {
        public SetTestModeRunnable() {
            super(new OuyaResponseListener(){

                public void onSuccess(Object result) {
                }

                public void onFailure(int errorCode, String errorMessage, Bundle optionalData) {
                }

                public void onCancel() {
                }
            }, "setting test mode");
        }

        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.setTestMode();
        }
    }
}

