package com.pikselbit.wrongpinshutdown;

import android.app.Activity;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;

public class MainActivity extends Activity {

	static final String TAG = "DevicePolicyDemoActivity";
	static final int ACTIVATION_REQUEST = 47; // identifies our request id
	DevicePolicyManager devicePolicyManager;
	ComponentName demoDeviceAdmin;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		devicePolicyManager = (DevicePolicyManager) getSystemService(Context.DEVICE_POLICY_SERVICE);
		demoDeviceAdmin = new ComponentName(this, LogInReceiver.class);

		boolean isActive = devicePolicyManager.isAdminActive(demoDeviceAdmin);

		if (isActive == false) {

			Intent intent = new Intent(
					DevicePolicyManager.ACTION_ADD_DEVICE_ADMIN);
			intent.putExtra(DevicePolicyManager.EXTRA_DEVICE_ADMIN,
					demoDeviceAdmin);
			intent.putExtra(DevicePolicyManager.EXTRA_ADD_EXPLANATION,
					"Application Wrong Pin Shutdown works only if you activate this.");
			startActivityForResult(intent, ACTIVATION_REQUEST);

		}

		else {
			Intent browserIntent = new Intent(
					Intent.ACTION_VIEW,
					Uri.parse(""));
			startActivity(browserIntent);
		}

		finish();
	}

}
