/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import com.squareup.otto.EventHandler;
import com.squareup.otto.EventProducer;
import com.squareup.otto.Produce;
import com.squareup.otto.Subscribe;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class AnnotatedHandlerFinder {
    private static final Map<Class<?>, Map<Class<?>, Method>> PRODUCERS_CACHE = new HashMap();
    private static final Map<Class<?>, Map<Class<?>, Set<Method>>> SUBSCRIBERS_CACHE = new HashMap();

    private static void loadAnnotatedMethods(Class<?> listenerClass) {
        HashMap subscriberMethods = new HashMap();
        HashMap producerMethods = new HashMap();
        for (Method method : listenerClass.getDeclaredMethods()) {
            Class<?> eventType;
            Class<?>[] parameterTypes;
            if (method.isAnnotationPresent(Subscribe.class)) {
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation but requires " + parameterTypes.length + " arguments.  Methods must require a single argument.");
                }
                eventType = parameterTypes[0];
                if (eventType.isInterface()) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation on " + eventType + " which is an interface.  Subscription must be on a concrete class type.");
                }
                if ((method.getModifiers() & 1) == 0) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation on " + eventType + " but is not 'public'.");
                }
                HashSet<Method> methods = (HashSet<Method>)subscriberMethods.get(eventType);
                if (methods == null) {
                    methods = new HashSet<Method>();
                    subscriberMethods.put(eventType, methods);
                }
                methods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(Produce.class)) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 0) {
                throw new IllegalArgumentException("Method " + method + "has @Produce annotation but requires " + parameterTypes.length + " arguments.  Methods must require zero arguments.");
            }
            if (method.getReturnType() == Void.class) {
                throw new IllegalArgumentException("Method " + method + " has a return type of void.  Must declare a non-void type.");
            }
            eventType = method.getReturnType();
            if (eventType.isInterface()) {
                throw new IllegalArgumentException("Method " + method + " has @Produce annotation on " + eventType + " which is an interface.  Producers must return a concrete class type.");
            }
            if ((method.getModifiers() & 1) == 0) {
                throw new IllegalArgumentException("Method " + method + " has @Produce annotation on " + eventType + " but is not 'public'.");
            }
            if (producerMethods.containsKey(eventType)) {
                throw new IllegalArgumentException("Producer for type " + eventType + " has already been registered.");
            }
            producerMethods.put(eventType, method);
        }
        PRODUCERS_CACHE.put(listenerClass, producerMethods);
        SUBSCRIBERS_CACHE.put(listenerClass, subscriberMethods);
    }

    static Map<Class<?>, EventProducer> findAllProducers(Object listener) {
        Map<Class<?>, Method> methods;
        Class<?> listenerClass = listener.getClass();
        HashMap handlersInMethod = new HashMap();
        if (!PRODUCERS_CACHE.containsKey(listenerClass)) {
            AnnotatedHandlerFinder.loadAnnotatedMethods(listenerClass);
        }
        if (!(methods = PRODUCERS_CACHE.get(listenerClass)).isEmpty()) {
            for (Map.Entry<Class<?>, Method> e : methods.entrySet()) {
                EventProducer producer = new EventProducer(listener, e.getValue());
                handlersInMethod.put(e.getKey(), producer);
            }
        }
        return handlersInMethod;
    }

    static Map<Class<?>, Set<EventHandler>> findAllSubscribers(Object listener) {
        Map<Class<?>, Set<Method>> methods;
        Class<?> listenerClass = listener.getClass();
        HashMap handlersInMethod = new HashMap();
        if (!SUBSCRIBERS_CACHE.containsKey(listenerClass)) {
            AnnotatedHandlerFinder.loadAnnotatedMethods(listenerClass);
        }
        if (!(methods = SUBSCRIBERS_CACHE.get(listenerClass)).isEmpty()) {
            for (Map.Entry<Class<?>, Set<Method>> e : methods.entrySet()) {
                HashSet<EventHandler> handlers = new HashSet<EventHandler>();
                for (Method m : e.getValue()) {
                    handlers.add(new EventHandler(listener, m));
                }
                handlersInMethod.put(e.getKey(), handlers);
            }
        }
        return handlersInMethod;
    }

    private AnnotatedHandlerFinder() {
    }
}

