package com.psrivastava.deviceframegenerator.devices;

import com.psrivastava.deviceframegenerator.AppConstants;
import com.psrivastava.deviceframegenerator.R;

public class GalaxyNexus {

	private static final String id = AppConstants.GALAXY_NEXUS;
	private static final String title = "Galaxy Nexus";
	private static final String url = "http://www.android.com/devices/detail/galaxy-nexus";

	private static final float physicalSize = 4.65f;
	private static final int density = 320;

	private static final int[] landOffset = { 371, 199 };
	private static final int[] portOffset = { 216, 353 };

	private static final int[] portSize = { 720, 1280 };

	public static String getId() {
		return id;
	}

	public static String getTitle() {
		return title;
	}

	public static String getUrl() {
		return url;
	}

	public static float getPhysicalsize() {
		return physicalSize;
	}

	public static int getDensity() {
		return density;
	}

	public static int[] getLandoffset() {
		return landOffset;
	}

	public static int[] getPortoffset() {
		return portOffset;
	}

	public static int[] getPortsize() {
		return portSize;
	}
	
	public static int getThumbnail(){
		return R.drawable.galaxy_nexus_thumb;
	}

}
