/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import org.acra.ACRAConfigurationException;
import org.acra.ErrorReporter;
import org.acra.annotation.ReportsCrashes;

public class ACRA {
    protected static final String LOG_TAG = ACRA.class.getSimpleName();
    static final String RES_NOTIF_ICON = "RES_NOTIF_ICON";
    static final String RES_NOTIF_TICKER_TEXT = "RES_NOTIF_TICKER_TEXT";
    static final String RES_NOTIF_TITLE = "RES_NOTIF_TITLE";
    static final String RES_NOTIF_TEXT = "RES_NOTIF_TEXT";
    static final String RES_DIALOG_ICON = "RES_DIALOG_ICON";
    static final String RES_DIALOG_TITLE = "RES_DIALOG_TITLE";
    static final String RES_DIALOG_TEXT = "RES_DIALOG_TEXT";
    static final String RES_DIALOG_COMMENT_PROMPT = "RES_DIALOG_COMMENT_PROMPT";
    static final String RES_DIALOG_OK_TOAST = "RES_DIALOG_OK_TOAST";
    static final String RES_TOAST_TEXT = "RES_TOAST_TEXT";
    static final int NOTIF_CRASH_ID = 666;
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    private static Application mApplication;
    private static ReportsCrashes mReportsCrashes;
    private static Bundle mCrashResources;
    private static SharedPreferences.OnSharedPreferenceChangeListener mPrefListener;

    public static void init(Application app) {
        mApplication = app;
        mReportsCrashes = mApplication.getClass().getAnnotation(ReportsCrashes.class);
        if (mReportsCrashes != null) {
            SharedPreferences prefs = ACRA.getACRASharedPreferences();
            Log.d((String)LOG_TAG, (String)"Set OnSharedPreferenceChangeListener.");
            mPrefListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

                public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                    Log.d((String)LOG_TAG, (String)"Preferences changed, check if ACRA configuration must change.");
                    if (ACRA.PREF_DISABLE_ACRA.equals(key) || ACRA.PREF_ENABLE_ACRA.equals(key)) {
                        Boolean disableAcra = false;
                        try {
                            disableAcra = sharedPreferences.getBoolean(ACRA.PREF_DISABLE_ACRA, !sharedPreferences.getBoolean(ACRA.PREF_ENABLE_ACRA, true));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (disableAcra.booleanValue()) {
                            ErrorReporter.getInstance().disable();
                        } else {
                            try {
                                ACRA.initAcra();
                            }
                            catch (ACRAConfigurationException e) {
                                Log.w((String)LOG_TAG, (String)"Error : ", (Throwable)e);
                            }
                        }
                    }
                }
            };
            boolean disableAcra = false;
            try {
                disableAcra = prefs.getBoolean(PREF_DISABLE_ACRA, !prefs.getBoolean(PREF_ENABLE_ACRA, true));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (disableAcra) {
                Log.d((String)LOG_TAG, (String)("ACRA is disabled for " + mApplication.getPackageName() + "."));
                return;
            }
            try {
                ACRA.initAcra();
            }
            catch (ACRAConfigurationException e) {
                Log.w((String)LOG_TAG, (String)"Error : ", (Throwable)e);
            }
            prefs.registerOnSharedPreferenceChangeListener(mPrefListener);
        }
    }

    private static void initAcra() throws ACRAConfigurationException {
        ACRA.initCrashResources();
        Log.d((String)LOG_TAG, (String)("ACRA is enabled for " + mApplication.getPackageName() + ", intializing..."));
        ErrorReporter errorReporter = ErrorReporter.getInstance();
        errorReporter.setFormUri(ACRA.getFormUri());
        errorReporter.setReportingInteractionMode(mReportsCrashes.mode());
        errorReporter.setCrashResources(ACRA.getCrashResources());
        errorReporter.init(mApplication.getApplicationContext());
        errorReporter.checkReportsOnApplicationStart();
    }

    static void initCrashResources() throws ACRAConfigurationException {
        mCrashResources = new Bundle();
        switch (mReportsCrashes.mode()) {
            case TOAST: {
                if (mReportsCrashes.resToastText() == 0) {
                    throw new ACRAConfigurationException("TOAST mode: you have to define the resToastText parameter in your application @ReportsCrashes() annotation.");
                }
                mCrashResources.putInt(RES_TOAST_TEXT, mReportsCrashes.resToastText());
                break;
            }
            case NOTIFICATION: {
                if (mReportsCrashes.resNotifTickerText() != 0 && mReportsCrashes.resNotifTitle() != 0 && mReportsCrashes.resNotifText() != 0 && mReportsCrashes.resDialogText() != 0) {
                    mCrashResources.putInt(RES_NOTIF_TICKER_TEXT, mReportsCrashes.resNotifTickerText());
                    mCrashResources.putInt(RES_NOTIF_TITLE, mReportsCrashes.resNotifTitle());
                    mCrashResources.putInt(RES_NOTIF_TEXT, mReportsCrashes.resNotifText());
                    mCrashResources.putInt(RES_DIALOG_TEXT, mReportsCrashes.resDialogText());
                    mCrashResources.putInt(RES_NOTIF_ICON, mReportsCrashes.resNotifIcon());
                    mCrashResources.putInt(RES_DIALOG_ICON, mReportsCrashes.resDialogIcon());
                    mCrashResources.putInt(RES_DIALOG_TITLE, mReportsCrashes.resDialogTitle());
                    mCrashResources.putInt(RES_DIALOG_COMMENT_PROMPT, mReportsCrashes.resDialogCommentPrompt());
                    mCrashResources.putInt(RES_DIALOG_OK_TOAST, mReportsCrashes.resDialogOkToast());
                    break;
                }
                throw new ACRAConfigurationException("NOTIFICATION mode: you have to define at least the resNotifTickerText, resNotifTitle, resNotifText, resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
        }
    }

    static Bundle getCrashResources() {
        return mCrashResources;
    }

    private static Uri getFormUri() {
        return mReportsCrashes.formUri().equals("") ? Uri.parse((String)("http://spreadsheets.google.com/formResponse?formkey=" + mReportsCrashes.formKey() + "&amp;ifq")) : Uri.parse((String)mReportsCrashes.formUri());
    }

    public static SharedPreferences getACRASharedPreferences() {
        if (!"".equals(mReportsCrashes.sharedPreferencesName())) {
            Log.d((String)LOG_TAG, (String)("Retrieve SharedPreferences " + mReportsCrashes.sharedPreferencesName()));
            return mApplication.getSharedPreferences(mReportsCrashes.sharedPreferencesName(), mReportsCrashes.sharedPreferencesMode());
        }
        Log.d((String)LOG_TAG, (String)"Retrieve application default SharedPreferences.");
        return PreferenceManager.getDefaultSharedPreferences((Context)mApplication);
    }
}

